/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfua.checkers.utils.ua2;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.tagging.IStructureNode;
import com.itextpdf.kernel.pdf.tagging.PdfObjRef;
import com.itextpdf.kernel.pdf.tagging.PdfStructElem;
import com.itextpdf.pdfua.checkers.utils.ContextAwareTagTreeIteratorHandler;
import com.itextpdf.pdfua.checkers.utils.PdfUAValidationContext;
import com.itextpdf.pdfua.exceptions.PdfUAConformanceException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PdfUA2LinkChecker {
    private final PdfDocument pdfDoc;
    private final PdfUAValidationContext context;
    private final Map<PdfObject, Set<IStructureNode>> destinationToStructParentsMap = new HashMap<PdfObject, Set<IStructureNode>>();

    private PdfUA2LinkChecker(PdfUAValidationContext context, PdfDocument pdfDoc) {
        this.context = context;
        this.pdfDoc = pdfDoc;
    }

    public static void checkLinkAnnotations(PdfDocument document) {
        int amountOfPages = document.getNumberOfPages();
        for (int i = 1; i <= amountOfPages; ++i) {
            PdfPage page = document.getPage(i);
            for (PdfAnnotation annot : page.getAnnotations()) {
                if (!(annot instanceof PdfLinkAnnotation) || annot.getStructParentIndex() != -1) continue;
                throw new PdfUAConformanceException("A link annotation is either not tagged or not nested within a <Link> or <Reference> tag.");
            }
        }
    }

    private void checkLinkAnnotationStructureParent(IStructureNode elem) {
        PdfStructElem parentRef;
        if (!(elem instanceof PdfObjRef) || ((PdfObjRef)elem).getReferencedObject() == null) {
            return;
        }
        PdfName subtype = ((PdfObjRef)elem).getReferencedObject().getAsName(PdfName.Subtype);
        if (!PdfName.Link.equals((Object)subtype)) {
            return;
        }
        IStructureNode linkParent = elem.getParent();
        PdfStructElem parentLink = this.context.getElementIfRoleMatches(PdfName.Link, linkParent);
        if (parentLink == null && (parentRef = this.context.getElementIfRoleMatches(PdfName.Reference, linkParent)) == null) {
            throw new PdfUAConformanceException("A link annotation is either not tagged or not nested within a <Link> or <Reference> tag.");
        }
        this.checkStructDestinationsInLinkAndReference((PdfObjRef)elem);
    }

    private void checkStructDestinationsInLinkAndReference(PdfObjRef objRef) {
        IStructureNode parent = objRef.getParent();
        if (parent == null) {
            return;
        }
        PdfObject structDestination = this.getStructureDestinationObject(objRef.getReferencedObject());
        if (structDestination == null) {
            return;
        }
        for (Map.Entry<PdfObject, Set<IStructureNode>> entry : this.destinationToStructParentsMap.entrySet()) {
            if (structDestination.equals(entry.getKey())) continue;
            for (IStructureNode parentNode : entry.getValue()) {
                if (!parent.equals(parentNode)) continue;
                throw new PdfUAConformanceException("Link annotations that target different locations shall be in separate Link or Reference structure elements instead of a single one.");
            }
        }
        Set destinationStructParents = this.destinationToStructParentsMap.computeIfAbsent(structDestination, k -> new HashSet());
        destinationStructParents.add(parent);
    }

    private PdfObject getStructureDestinationObject(PdfDictionary annotObj) {
        PdfLinkAnnotation linkAnnotation = (PdfLinkAnnotation)PdfAnnotation.makeAnnotation((PdfObject)annotObj);
        PdfObject destination = null;
        PdfDictionary action = linkAnnotation.getAction();
        if (action != null) {
            if (PdfName.GoTo.equals((Object)action.getAsName(PdfName.S)) && (destination = action.get(PdfName.SD)) == null) {
                destination = action.get(PdfName.D);
            }
        } else {
            destination = linkAnnotation.getDestinationObject();
        }
        if (destination == null) {
            return null;
        }
        PdfArray dest = this.getDestination(destination);
        if (dest == null || dest.isEmpty()) {
            return null;
        }
        return dest.get(0);
    }

    private PdfArray getDestination(PdfObject destination) {
        return this.getDestination(destination, new HashSet<PdfObject>());
    }

    private PdfArray getDestination(PdfObject destination, Set<PdfObject> checkedDestinations) {
        if (destination == null || checkedDestinations.contains(destination)) {
            return null;
        }
        checkedDestinations.add(destination);
        switch (destination.getType()) {
            case 10: {
                PdfNameTree destinations = this.pdfDoc.getCatalog().getNameTree(PdfName.Dests);
                destination = this.getDestination(destinations.getEntry((PdfString)destination), checkedDestinations);
                break;
            }
            case 6: {
                PdfDictionary dests = ((PdfDictionary)this.pdfDoc.getCatalog().getPdfObject()).getAsDictionary(PdfName.Dests);
                if (dests == null) break;
                destination = this.getDestination(dests.get((PdfName)destination), checkedDestinations);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                PdfArray actualDestinationObject = this.getDestination(((PdfDictionary)destination).get(PdfName.SD), checkedDestinations);
                if (actualDestinationObject == null) {
                    destination = this.getDestination(((PdfDictionary)destination).get(PdfName.D), checkedDestinations);
                    break;
                }
                destination = actualDestinationObject;
                break;
            }
            default: {
                return null;
            }
        }
        if (destination instanceof PdfArray) {
            return (PdfArray)destination;
        }
        return null;
    }

    public static class PdfUA2LinkAnnotationHandler
    extends ContextAwareTagTreeIteratorHandler {
        private final PdfUA2LinkChecker checker;

        public PdfUA2LinkAnnotationHandler(PdfUAValidationContext context, PdfDocument document) {
            super(context);
            this.checker = new PdfUA2LinkChecker(context, document);
        }

        public boolean accept(IStructureNode node) {
            return node != null;
        }

        public void processElement(IStructureNode elem) {
            this.checker.checkLinkAnnotationStructureParent(elem);
        }
    }
}

