/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.tagging;

import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfVersion;
import com.itextpdf.kernel.pdf.tagutils.TagStructureContext;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.tagutils.WaitingTagsManager;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILargeElement;
import com.itextpdf.layout.renderer.AreaBreakRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.layout.tagging.ITaggingRule;
import com.itextpdf.layout.tagging.THTaggingRule;
import com.itextpdf.layout.tagging.TableTaggingPriorToOneFiveVersionRule;
import com.itextpdf.layout.tagging.TableTaggingRule;
import com.itextpdf.layout.tagging.TaggingDummyElement;
import com.itextpdf.layout.tagging.TaggingHintKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutTaggingHelper {
    private final TagStructureContext context;
    private final PdfDocument document;
    private final boolean immediateFlush;
    private final Map<TaggingHintKey, List<TaggingHintKey>> kidsHints;
    private final Map<TaggingHintKey, TaggingHintKey> parentHints;
    private final Map<IRenderer, TagTreePointer> autoTaggingPointerSavedPosition;
    private final Map<String, List<ITaggingRule>> taggingRules;
    private final Map<PdfObject, TaggingDummyElement> dummiesForPreExistingTags;
    private final int RETVAL_NO_PARENT = -1;
    private final int RETVAL_PARENT_AND_KID_FINISHED = -2;

    public LayoutTaggingHelper(PdfDocument document, boolean immediateFlush) {
        this.document = document;
        this.context = document.getTagStructureContext();
        this.immediateFlush = immediateFlush;
        this.kidsHints = new LinkedHashMap<TaggingHintKey, List<TaggingHintKey>>();
        this.parentHints = new LinkedHashMap<TaggingHintKey, TaggingHintKey>();
        this.autoTaggingPointerSavedPosition = new HashMap<IRenderer, TagTreePointer>();
        this.taggingRules = new HashMap<String, List<ITaggingRule>>();
        this.registerRules(this.context.getTagStructureTargetVersion());
        this.dummiesForPreExistingTags = new LinkedHashMap<PdfObject, TaggingDummyElement>();
    }

    public static void addTreeHints(LayoutTaggingHelper taggingHelper, IRenderer rootRenderer) {
        List<IRenderer> childRenderers = rootRenderer.getChildRenderers();
        if (childRenderers == null) {
            return;
        }
        taggingHelper.addKidsHint(rootRenderer, childRenderers);
        for (IRenderer childRenderer : childRenderers) {
            LayoutTaggingHelper.addTreeHints(taggingHelper, childRenderer);
        }
    }

    public static TaggingHintKey getHintKey(IPropertyContainer container) {
        return (TaggingHintKey)container.getProperty(109);
    }

    public static TaggingHintKey getOrCreateHintKey(IPropertyContainer container) {
        return LayoutTaggingHelper.getOrCreateHintKey(container, true);
    }

    public void addKidsHint(TagTreePointer parentPointer, Iterable<? extends IPropertyContainer> newKids) {
        PdfDictionary pointerStructElem = (PdfDictionary)this.context.getPointerStructElem(parentPointer).getPdfObject();
        TaggingDummyElement dummy = this.dummiesForPreExistingTags.get(pointerStructElem);
        if (dummy == null) {
            dummy = new TaggingDummyElement(parentPointer.getRole());
            this.dummiesForPreExistingTags.put((PdfObject)pointerStructElem, dummy);
        }
        this.context.getWaitingTagsManager().assignWaitingState(parentPointer, (Object)LayoutTaggingHelper.getOrCreateHintKey(dummy));
        this.addKidsHint(dummy, newKids);
    }

    public void addKidsHint(IPropertyContainer parent, Iterable<? extends IPropertyContainer> newKids) {
        this.addKidsHint(parent, newKids, -1);
    }

    public void addKidsHint(IPropertyContainer parent, Iterable<? extends IPropertyContainer> newKids, int insertIndex) {
        if (parent instanceof AreaBreakRenderer) {
            return;
        }
        TaggingHintKey parentKey = LayoutTaggingHelper.getOrCreateHintKey(parent);
        ArrayList<TaggingHintKey> newKidsKeys = new ArrayList<TaggingHintKey>();
        for (IPropertyContainer iPropertyContainer : newKids) {
            if (iPropertyContainer instanceof AreaBreakRenderer) {
                return;
            }
            newKidsKeys.add(LayoutTaggingHelper.getOrCreateHintKey(iPropertyContainer));
        }
        this.addKidsHint(parentKey, newKidsKeys, insertIndex);
    }

    public void addKidsHint(TaggingHintKey parentKey, Collection<TaggingHintKey> newKidsKeys) {
        this.addKidsHint(parentKey, newKidsKeys, -1);
    }

    public void addKidsHint(TaggingHintKey parentKey, Collection<TaggingHintKey> newKidsKeys, int insertIndex) {
        this.addKidsHint(parentKey, newKidsKeys, insertIndex, false);
    }

    public void setRoleHint(IPropertyContainer hintOwner, String role) {
        LayoutTaggingHelper.getOrCreateHintKey(hintOwner).setOverriddenRole(role);
    }

    public boolean isArtifact(IPropertyContainer hintOwner) {
        TaggingHintKey key = LayoutTaggingHelper.getHintKey(hintOwner);
        if (key != null) {
            return key.isArtifact();
        }
        IAccessibleElement aElem = null;
        if (hintOwner instanceof IRenderer && ((IRenderer)hintOwner).getModelElement() instanceof IAccessibleElement) {
            aElem = (IAccessibleElement)((Object)((IRenderer)hintOwner).getModelElement());
        } else if (hintOwner instanceof IAccessibleElement) {
            aElem = (IAccessibleElement)((Object)hintOwner);
        }
        if (aElem != null) {
            return "Artifact".equals(aElem.getAccessibilityProperties().getRole());
        }
        return false;
    }

    public void markArtifactHint(IPropertyContainer hintOwner) {
        TaggingHintKey hintKey = LayoutTaggingHelper.getOrCreateHintKey(hintOwner);
        this.markArtifactHint(hintKey);
    }

    public void markArtifactHint(TaggingHintKey hintKey) {
        hintKey.setArtifact();
        hintKey.setFinished();
        TagTreePointer existingArtifactTag = new TagTreePointer(this.document);
        if (this.context.getWaitingTagsManager().tryMovePointerToWaitingTag(existingArtifactTag, (Object)hintKey)) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("A layout tagging hint for which an actual tag was already created in tags structure is marked as artifact. Existing tag will be left in the tags tree.");
            this.context.getWaitingTagsManager().removeWaitingState((Object)hintKey);
            if (this.immediateFlush) {
                existingArtifactTag.flushParentsIfAllKidsFlushed();
            }
        }
        List<TaggingHintKey> kidsHint = this.getKidsHint(hintKey);
        for (TaggingHintKey kidKey : kidsHint) {
            this.markArtifactHint(kidKey);
        }
        this.removeParentHint(hintKey);
    }

    public TagTreePointer useAutoTaggingPointerAndRememberItsPosition(IRenderer renderer) {
        TagTreePointer autoTaggingPointer = this.context.getAutoTaggingPointer();
        TagTreePointer position = new TagTreePointer(autoTaggingPointer);
        this.autoTaggingPointerSavedPosition.put(renderer, position);
        return autoTaggingPointer;
    }

    public void restoreAutoTaggingPointerPosition(IRenderer renderer) {
        TagTreePointer autoTaggingPointer = this.context.getAutoTaggingPointer();
        TagTreePointer position = this.autoTaggingPointerSavedPosition.remove(renderer);
        if (position != null) {
            autoTaggingPointer.moveToPointer(position);
        }
    }

    public List<TaggingHintKey> getKidsHint(TaggingHintKey parent) {
        List<TaggingHintKey> kidsHint = this.kidsHints.get(parent);
        if (kidsHint == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(kidsHint);
    }

    public List<TaggingHintKey> getAccessibleKidsHint(TaggingHintKey parent) {
        List<TaggingHintKey> kidsHint = this.kidsHints.get(parent);
        if (kidsHint == null) {
            return Collections.emptyList();
        }
        ArrayList<TaggingHintKey> accessibleKids = new ArrayList<TaggingHintKey>();
        for (TaggingHintKey kid : kidsHint) {
            if (LayoutTaggingHelper.isNonAccessibleHint(kid)) {
                accessibleKids.addAll(this.getAccessibleKidsHint(kid));
                continue;
            }
            accessibleKids.add(kid);
        }
        return accessibleKids;
    }

    public TaggingHintKey getParentHint(IPropertyContainer hintOwner) {
        TaggingHintKey hintKey = LayoutTaggingHelper.getHintKey(hintOwner);
        if (hintKey == null) {
            return null;
        }
        return this.getParentHint(hintKey);
    }

    public TaggingHintKey getParentHint(TaggingHintKey hintKey) {
        return this.parentHints.get(hintKey);
    }

    public TaggingHintKey getAccessibleParentHint(TaggingHintKey hintKey) {
        while ((hintKey = this.getParentHint(hintKey)) != null && LayoutTaggingHelper.isNonAccessibleHint(hintKey)) {
        }
        return hintKey;
    }

    public void releaseFinishedHints() {
        HashSet<TaggingHintKey> allHints = new HashSet<TaggingHintKey>();
        for (Map.Entry<TaggingHintKey, TaggingHintKey> entry : this.parentHints.entrySet()) {
            allHints.add(entry.getKey());
            allHints.add(entry.getValue());
        }
        for (TaggingHintKey hint : allHints) {
            if (!hint.isFinished() || LayoutTaggingHelper.isNonAccessibleHint(hint) || hint.getAccessibleElement() instanceof TaggingDummyElement) continue;
            this.finishDummyKids(this.getKidsHint(hint));
        }
        HashSet<TaggingHintKey> hintsToBeHeld = new HashSet<TaggingHintKey>();
        for (TaggingHintKey hint : allHints) {
            if (LayoutTaggingHelper.isNonAccessibleHint(hint)) continue;
            List<TaggingHintKey> siblingsHints = this.getAccessibleKidsHint(hint);
            boolean holdTheFirstFinishedToBeFound = false;
            for (TaggingHintKey sibling : siblingsHints) {
                if (!sibling.isFinished()) {
                    holdTheFirstFinishedToBeFound = true;
                    continue;
                }
                if (!holdTheFirstFinishedToBeFound) continue;
                hintsToBeHeld.add(sibling);
                holdTheFirstFinishedToBeFound = false;
            }
        }
        for (TaggingHintKey hint : allHints) {
            if (!hint.isFinished()) continue;
            this.releaseHint(hint, hintsToBeHeld, true);
        }
    }

    public void releaseAllHints() {
        for (TaggingDummyElement dummy : this.dummiesForPreExistingTags.values()) {
            this.finishTaggingHint(dummy);
            this.finishDummyKids(this.getKidsHint(LayoutTaggingHelper.getHintKey(dummy)));
        }
        this.dummiesForPreExistingTags.clear();
        this.releaseFinishedHints();
        HashSet<TaggingHintKey> hangingHints = new HashSet<TaggingHintKey>();
        for (Map.Entry<TaggingHintKey, TaggingHintKey> entry : this.parentHints.entrySet()) {
            hangingHints.add(entry.getKey());
            hangingHints.add(entry.getValue());
        }
        for (TaggingHintKey hint : hangingHints) {
            this.releaseHint(hint, null, false);
        }
        assert (this.parentHints.isEmpty());
        assert (this.kidsHints.isEmpty());
    }

    public boolean createTag(IRenderer renderer, TagTreePointer tagPointer) {
        boolean noHint;
        TaggingHintKey hintKey = LayoutTaggingHelper.getHintKey(renderer);
        boolean bl = noHint = hintKey == null;
        if (noHint) {
            hintKey = LayoutTaggingHelper.getOrCreateHintKey(renderer, false);
        }
        boolean created = this.createTag(hintKey, tagPointer);
        if (noHint) {
            hintKey.setFinished();
            this.context.getWaitingTagsManager().removeWaitingState((Object)hintKey);
        }
        return created;
    }

    public boolean createTag(TaggingHintKey hintKey, TagTreePointer tagPointer) {
        if (hintKey.isArtifact()) {
            return false;
        }
        boolean created = this.createSingleTag(hintKey, tagPointer);
        if (created) {
            List<TaggingHintKey> kidsHint = this.getAccessibleKidsHint(hintKey);
            for (TaggingHintKey hint : kidsHint) {
                if (!(hint.getAccessibleElement() instanceof TaggingDummyElement)) continue;
                this.createTag(hint, new TagTreePointer(this.document));
            }
        }
        return created;
    }

    public void finishTaggingHint(IPropertyContainer hintOwner) {
        TaggingHintKey rendererKey = LayoutTaggingHelper.getHintKey(hintOwner);
        if (rendererKey == null || rendererKey.isFinished()) {
            return;
        }
        if (rendererKey.isElementBasedFinishingOnly() && !(hintOwner instanceof IElement)) {
            return;
        }
        if (!LayoutTaggingHelper.isNonAccessibleHint(rendererKey)) {
            IAccessibleElement modelElement = rendererKey.getAccessibleElement();
            String role = modelElement.getAccessibilityProperties().getRole();
            if (rendererKey.getOverriddenRole() != null) {
                role = rendererKey.getOverriddenRole();
            }
            List<ITaggingRule> rules = this.taggingRules.get(role);
            boolean ruleResult = true;
            if (rules != null) {
                for (ITaggingRule rule : rules) {
                    ruleResult = ruleResult && rule.onTagFinish(this, rendererKey);
                }
            }
            if (!ruleResult) {
                return;
            }
        }
        rendererKey.setFinished();
    }

    public int replaceKidHint(TaggingHintKey kidHintKey, Collection<TaggingHintKey> newKidsHintKeys) {
        TaggingHintKey parentKey = this.getParentHint(kidHintKey);
        if (parentKey == null) {
            return -1;
        }
        if (kidHintKey.isFinished()) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("Layout tagging hints modification failed: cannot replace a kid hint that is already marked as finished.");
            return -1;
        }
        int kidIndex = this.removeParentHint(kidHintKey);
        ArrayList<TaggingHintKey> kidsToBeAdded = new ArrayList<TaggingHintKey>();
        for (TaggingHintKey newKidKey : newKidsHintKeys) {
            int i = this.removeParentHint(newKidKey);
            if (i == -2 || i == -1 && newKidKey.isFinished()) {
                Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
                logger.error("Layout tagging hints modification failed: cannot move kid hint for which both itself and it's parent are already marked as finished.");
                continue;
            }
            kidsToBeAdded.add(newKidKey);
        }
        this.addKidsHint(parentKey, kidsToBeAdded, kidIndex, true);
        return kidIndex;
    }

    public int moveKidHint(TaggingHintKey hintKeyOfKidToMove, TaggingHintKey newParent) {
        return this.moveKidHint(hintKeyOfKidToMove, newParent, -1);
    }

    public int moveKidHint(TaggingHintKey hintKeyOfKidToMove, TaggingHintKey newParent, int insertIndex) {
        if (newParent.isFinished()) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("Layout tagging hints modification failed: cannot move kid hint to a parent that is already marked as finished.");
            return -1;
        }
        int removeRes = this.removeParentHint(hintKeyOfKidToMove);
        if (removeRes == -2 || removeRes == -1 && hintKeyOfKidToMove.isFinished()) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("Layout tagging hints modification failed: cannot move kid hint for which both itself and it's parent are already marked as finished.");
            return -1;
        }
        this.addKidsHint(newParent, Collections.singletonList(hintKeyOfKidToMove), insertIndex, true);
        return removeRes;
    }

    public PdfDocument getPdfDocument() {
        return this.document;
    }

    private static TaggingHintKey getOrCreateHintKey(IPropertyContainer hintOwner, boolean setProperty) {
        TaggingHintKey hintKey = (TaggingHintKey)hintOwner.getProperty(109);
        if (hintKey == null) {
            IAccessibleElement elem = null;
            if (hintOwner instanceof IAccessibleElement) {
                elem = (IAccessibleElement)((Object)hintOwner);
            } else if (hintOwner instanceof IRenderer && ((IRenderer)hintOwner).getModelElement() instanceof IAccessibleElement) {
                elem = (IAccessibleElement)((Object)((IRenderer)hintOwner).getModelElement());
            }
            hintKey = new TaggingHintKey(elem, hintOwner instanceof IElement);
            if (elem != null && "Artifact".equals(elem.getAccessibilityProperties().getRole())) {
                hintKey.setArtifact();
                hintKey.setFinished();
            }
            if (setProperty) {
                if (elem instanceof ILargeElement && !((ILargeElement)((Object)elem)).isComplete()) {
                    ((ILargeElement)((Object)elem)).setProperty(109, hintKey);
                } else {
                    hintOwner.setProperty(109, hintKey);
                }
            }
        }
        return hintKey;
    }

    private void addKidsHint(TaggingHintKey parentKey, Collection<TaggingHintKey> newKidsKeys, int insertIndex, boolean skipFinishedChecks) {
        if (newKidsKeys.isEmpty()) {
            return;
        }
        if (parentKey.isArtifact()) {
            for (TaggingHintKey kid : newKidsKeys) {
                this.markArtifactHint(kid);
            }
            return;
        }
        if (!skipFinishedChecks && parentKey.isFinished()) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("Layout tagging hints addition failed: cannot add new kid hints to a parent which hint is already marked as finished. Consider using com.itextpdf.layout.tagging.LayoutTaggingHelper#replaceKidHint method for replacing not yet finished kid hint of a finished parent hint.");
            return;
        }
        List<TaggingHintKey> kidsHint = this.kidsHints.get(parentKey);
        if (kidsHint == null) {
            kidsHint = new ArrayList<TaggingHintKey>();
        }
        TaggingHintKey parentTagHint = LayoutTaggingHelper.isNonAccessibleHint(parentKey) ? this.getAccessibleParentHint(parentKey) : parentKey;
        boolean parentTagAlreadyCreated = parentTagHint != null && this.isTagAlreadyExistsForHint(parentTagHint);
        for (TaggingHintKey kidKey : newKidsKeys) {
            TaggingHintKey prevParent;
            if (kidKey.isArtifact() || (prevParent = this.getParentHint(kidKey)) != null) continue;
            if (!skipFinishedChecks && kidKey.isFinished()) {
                Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
                logger.error("Layout tagging hints addition failed: cannot add a hint that is already marked as finished. Consider using com.itextpdf.layout.tagging.LayoutTaggingHelper#moveKidHint method for moving already finished kid hint from not yet finished parent hint.");
                continue;
            }
            if (insertIndex > -1) {
                kidsHint.add(insertIndex++, kidKey);
            } else {
                kidsHint.add(kidKey);
            }
            this.kidsHints.put(parentKey, kidsHint);
            this.parentHints.put(kidKey, parentKey);
            if (!parentTagAlreadyCreated) continue;
            if (kidKey.getAccessibleElement() instanceof TaggingDummyElement) {
                this.createTag(kidKey, new TagTreePointer(this.document));
            }
            if (LayoutTaggingHelper.isNonAccessibleHint(kidKey)) {
                for (TaggingHintKey nestedKid : this.getAccessibleKidsHint(kidKey)) {
                    if (nestedKid.getAccessibleElement() instanceof TaggingDummyElement) {
                        this.createTag(nestedKid, new TagTreePointer(this.document));
                    }
                    this.moveKidTagIfCreated(parentTagHint, nestedKid);
                }
                continue;
            }
            this.moveKidTagIfCreated(parentTagHint, kidKey);
        }
    }

    private boolean createSingleTag(TaggingHintKey hintKey, TagTreePointer tagPointer) {
        if (hintKey.isFinished()) {
            Logger logger = LoggerFactory.getLogger(LayoutTaggingHelper.class);
            logger.error("Attempt to create a tag for a hint which is already marked as finished, tag will not be created.");
            return false;
        }
        if (LayoutTaggingHelper.isNonAccessibleHint(hintKey)) {
            TaggingHintKey parentTagHint = this.getAccessibleParentHint(hintKey);
            this.context.getWaitingTagsManager().tryMovePointerToWaitingTag(tagPointer, (Object)parentTagHint);
            return false;
        }
        WaitingTagsManager waitingTagsManager = this.context.getWaitingTagsManager();
        if (!waitingTagsManager.tryMovePointerToWaitingTag(tagPointer, (Object)hintKey)) {
            IAccessibleElement modelElement = hintKey.getAccessibleElement();
            TaggingHintKey parentHint = this.getAccessibleParentHint(hintKey);
            int ind = -1;
            if (parentHint != null && waitingTagsManager.tryMovePointerToWaitingTag(tagPointer, (Object)parentHint)) {
                ind = this.getNearestNextSiblingIndex(waitingTagsManager, tagPointer, parentHint, hintKey);
            }
            tagPointer.addTag(ind, modelElement.getAccessibilityProperties());
            hintKey.setTagPointer(new TagTreePointer(tagPointer));
            if (hintKey.getOverriddenRole() != null) {
                tagPointer.setRole(hintKey.getOverriddenRole());
            }
            waitingTagsManager.assignWaitingState(tagPointer, (Object)hintKey);
            List<TaggingHintKey> kidsHint = this.getAccessibleKidsHint(hintKey);
            for (TaggingHintKey kidKey : kidsHint) {
                this.moveKidTagIfCreated(hintKey, kidKey);
            }
            return true;
        }
        return false;
    }

    private int removeParentHint(TaggingHintKey hintKey) {
        TaggingHintKey parentHint = this.parentHints.get(hintKey);
        if (parentHint == null) {
            return -1;
        }
        TaggingHintKey accessibleParentHint = this.getAccessibleParentHint(hintKey);
        if (hintKey.isFinished() && parentHint.isFinished() && (accessibleParentHint == null || accessibleParentHint.isFinished())) {
            return -2;
        }
        return this.removeParentHint(hintKey, parentHint);
    }

    private int removeParentHint(TaggingHintKey hintKey, TaggingHintKey parentHint) {
        int i;
        this.parentHints.remove(hintKey);
        List<TaggingHintKey> kidsHint = this.kidsHints.get(parentHint);
        int size = kidsHint.size();
        for (i = 0; i < size; ++i) {
            if (kidsHint.get(i) != hintKey) continue;
            kidsHint.remove(i);
            break;
        }
        assert (i < size);
        if (kidsHint.isEmpty()) {
            this.kidsHints.remove(parentHint);
        }
        return i;
    }

    private void finishDummyKids(List<TaggingHintKey> taggingHintKeys) {
        for (TaggingHintKey hintKey : taggingHintKeys) {
            boolean isDummy = hintKey.getAccessibleElement() instanceof TaggingDummyElement;
            if (isDummy) {
                this.finishTaggingHint((IPropertyContainer)((Object)hintKey.getAccessibleElement()));
            }
            if (!LayoutTaggingHelper.isNonAccessibleHint(hintKey) && !isDummy) continue;
            this.finishDummyKids(this.getKidsHint(hintKey));
        }
    }

    private void moveKidTagIfCreated(TaggingHintKey parentKey, TaggingHintKey kidKey) {
        TagTreePointer kidPointer = new TagTreePointer(this.document);
        WaitingTagsManager waitingTagsManager = this.context.getWaitingTagsManager();
        if (!waitingTagsManager.tryMovePointerToWaitingTag(kidPointer, (Object)kidKey)) {
            return;
        }
        TagTreePointer parentPointer = new TagTreePointer(this.document);
        if (!waitingTagsManager.tryMovePointerToWaitingTag(parentPointer, (Object)parentKey)) {
            return;
        }
        int ind = this.getNearestNextSiblingIndex(waitingTagsManager, parentPointer, parentKey, kidKey);
        parentPointer.setNextNewKidIndex(ind);
        kidPointer.relocate(parentPointer);
    }

    private static boolean isNonAccessibleHint(TaggingHintKey hintKey) {
        return !hintKey.isAccessible();
    }

    private boolean isTagAlreadyExistsForHint(TaggingHintKey tagHint) {
        return this.context.getWaitingTagsManager().isObjectAssociatedWithWaitingTag((Object)tagHint);
    }

    private void releaseHint(TaggingHintKey hint, Set<TaggingHintKey> hintsToBeHeld, boolean checkContextIsFinished) {
        TaggingHintKey parentHint = this.parentHints.get(hint);
        List<TaggingHintKey> kidsHint = this.kidsHints.get(hint);
        if (checkContextIsFinished && parentHint != null && this.isSomeParentNotFinished(parentHint)) {
            return;
        }
        if (checkContextIsFinished && kidsHint != null && this.isSomeKidNotFinished(hint)) {
            return;
        }
        if (checkContextIsFinished && hintsToBeHeld != null && hintsToBeHeld.contains(hint)) {
            return;
        }
        if (parentHint != null) {
            this.removeParentHint(hint, parentHint);
        }
        if (kidsHint != null) {
            for (TaggingHintKey kidHint : kidsHint) {
                this.parentHints.remove(kidHint);
            }
            this.kidsHints.remove(hint);
        }
        TagTreePointer tagPointer = new TagTreePointer(this.document);
        if (this.context.getWaitingTagsManager().tryMovePointerToWaitingTag(tagPointer, (Object)hint)) {
            this.context.getWaitingTagsManager().removeWaitingState((Object)hint);
            if (this.immediateFlush) {
                tagPointer.flushParentsIfAllKidsFlushed();
            }
        } else {
            this.context.getWaitingTagsManager().removeWaitingState((Object)hint);
        }
    }

    private boolean isSomeParentNotFinished(TaggingHintKey parentHint) {
        TaggingHintKey hintKey = parentHint;
        while (hintKey != null) {
            if (!hintKey.isFinished()) {
                return true;
            }
            if (!LayoutTaggingHelper.isNonAccessibleHint(hintKey)) {
                return false;
            }
            hintKey = this.getParentHint(hintKey);
        }
        return false;
    }

    private boolean isSomeKidNotFinished(TaggingHintKey hint) {
        for (TaggingHintKey kidHint : this.getKidsHint(hint)) {
            if (!kidHint.isFinished()) {
                return true;
            }
            if (!LayoutTaggingHelper.isNonAccessibleHint(kidHint) || !this.isSomeKidNotFinished(kidHint)) continue;
            return true;
        }
        return false;
    }

    private void registerRules(PdfVersion pdfVersion) {
        TableTaggingRule tableRule = new TableTaggingRule();
        this.registerSingleRule("Table", tableRule);
        this.registerSingleRule("TFoot", tableRule);
        this.registerSingleRule("THead", tableRule);
        this.registerSingleRule("TH", new THTaggingRule());
        if (pdfVersion.compareTo(PdfVersion.PDF_1_5) < 0) {
            TableTaggingPriorToOneFiveVersionRule priorToOneFiveRule = new TableTaggingPriorToOneFiveVersionRule();
            this.registerSingleRule("Table", priorToOneFiveRule);
            this.registerSingleRule("THead", priorToOneFiveRule);
            this.registerSingleRule("TFoot", priorToOneFiveRule);
        }
    }

    private void registerSingleRule(String role, ITaggingRule rule) {
        List<ITaggingRule> rules = this.taggingRules.get(role);
        if (rules == null) {
            rules = new ArrayList<ITaggingRule>();
            this.taggingRules.put(role, rules);
        }
        rules.add(rule);
    }

    private int getNearestNextSiblingIndex(WaitingTagsManager waitingTagsManager, TagTreePointer parentPointer, TaggingHintKey parentKey, TaggingHintKey kidKey) {
        ScanContext scanContext = new ScanContext();
        scanContext.waitingTagsManager = waitingTagsManager;
        scanContext.startHintKey = kidKey;
        scanContext.parentPointer = parentPointer;
        scanContext.nextSiblingPointer = new TagTreePointer(this.document);
        return this.scanForNearestNextSiblingIndex(scanContext, null, parentKey);
    }

    private int scanForNearestNextSiblingIndex(ScanContext scanContext, TaggingHintKey toCheck, TaggingHintKey parent) {
        if (scanContext.startVerifying && scanContext.waitingTagsManager.tryMovePointerToWaitingTag(scanContext.nextSiblingPointer, (Object)toCheck) && scanContext.parentPointer.isPointingToSameTag(new TagTreePointer(scanContext.nextSiblingPointer).moveToParent())) {
            return scanContext.nextSiblingPointer.getIndexInParentKidsList();
        }
        if (toCheck != null && !LayoutTaggingHelper.isNonAccessibleHint(toCheck)) {
            return -1;
        }
        List<TaggingHintKey> kidsHintList = this.kidsHints.get(parent);
        if (kidsHintList == null) {
            return -1;
        }
        int startIndex = -1;
        if (!scanContext.startVerifying) {
            for (int i = kidsHintList.size() - 1; i >= 0; --i) {
                if (scanContext.startHintKey != kidsHintList.get(i)) continue;
                scanContext.startVerifying = true;
                startIndex = i;
                break;
            }
        }
        for (int j = startIndex + 1; j < kidsHintList.size(); ++j) {
            TaggingHintKey kid = kidsHintList.get(j);
            int interMediateResult = this.scanForNearestNextSiblingIndex(scanContext, kid, kid);
            if (interMediateResult == -1) continue;
            return interMediateResult;
        }
        return -1;
    }

    private static class ScanContext {
        WaitingTagsManager waitingTagsManager;
        TaggingHintKey startHintKey;
        boolean startVerifying;
        TagTreePointer parentPointer;
        TagTreePointer nextSiblingPointer;

        private ScanContext() {
        }
    }
}

