/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.NoninvertibleTransformException;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.border.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;

public class CellRenderer
extends BlockRenderer {
    public CellRenderer(Cell modelElement) {
        super(modelElement);
        assert (modelElement != null);
        this.setProperty(60, modelElement.getRowspan());
        this.setProperty(16, modelElement.getColspan());
    }

    @Override
    public Cell getModelElement() {
        return (Cell)super.getModelElement();
    }

    @Override
    protected Float retrieveWidth(float parentBoxWidth) {
        return null;
    }

    @Override
    protected CellRenderer createSplitRenderer(int layoutResult) {
        CellRenderer splitRenderer = (CellRenderer)this.getNextRenderer();
        splitRenderer.parent = this.parent;
        splitRenderer.modelElement = this.modelElement;
        splitRenderer.occupiedArea = this.occupiedArea;
        splitRenderer.isLastRendererForModelElement = false;
        splitRenderer.addAllProperties(this.getOwnProperties());
        return splitRenderer;
    }

    @Override
    protected CellRenderer createOverflowRenderer(int layoutResult) {
        CellRenderer overflowRenderer = (CellRenderer)this.getNextRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.modelElement = this.modelElement;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return overflowRenderer;
    }

    @Override
    public void drawBackground(DrawContext drawContext) {
        PdfCanvas canvas = drawContext.getCanvas();
        Matrix ctm = canvas.getGraphicsState().getCtm();
        Float angle = this.getPropertyAsFloat(55);
        boolean avoidRotation = null != angle && this.hasProperty(6);
        boolean restoreRotation = this.hasOwnProperty(55);
        if (avoidRotation) {
            AffineTransform transform = new AffineTransform((double)ctm.get(0), (double)ctm.get(1), (double)ctm.get(3), (double)ctm.get(4), (double)ctm.get(6), (double)ctm.get(7));
            try {
                transform = transform.createInverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            transform.concatenate(new AffineTransform());
            canvas.concatMatrix(transform);
            this.setProperty(55, null);
        }
        super.drawBackground(drawContext);
        if (avoidRotation) {
            if (restoreRotation) {
                this.setProperty(55, angle);
            } else {
                this.deleteOwnProperty(55);
            }
            canvas.concatMatrix(new AffineTransform((double)ctm.get(0), (double)ctm.get(1), (double)ctm.get(3), (double)ctm.get(4), (double)ctm.get(6), (double)ctm.get(7)));
        }
    }

    @Override
    public void drawBorder(DrawContext drawContext) {
    }

    @Override
    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        return rect;
    }

    @Override
    protected Rectangle applyMargins(Rectangle rect, float[] margins, boolean reverse) {
        return rect;
    }

    @Override
    public IRenderer getNextRenderer() {
        return new CellRenderer(this.getModelElement());
    }
}

