/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.hyphenation;

import com.itextpdf.layout.hyphenation.Hyphen;
import com.itextpdf.layout.hyphenation.HyphenationException;
import com.itextpdf.layout.hyphenation.IPatternConsumer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PatternParser
extends DefaultHandler {
    private XMLReader parser;
    private int currElement;
    private IPatternConsumer consumer;
    private StringBuilder token = new StringBuilder();
    private ArrayList exception;
    private char hyphenChar;
    private String errMsg;
    private boolean hasClasses;
    static final int ELEM_CLASSES = 1;
    static final int ELEM_EXCEPTIONS = 2;
    static final int ELEM_PATTERNS = 3;
    static final int ELEM_HYPHEN = 4;

    private PatternParser() throws HyphenationException {
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        this.hyphenChar = (char)45;
    }

    public PatternParser(IPatternConsumer consumer) throws HyphenationException {
        this();
        this.consumer = consumer;
    }

    public void parse(String filename) throws HyphenationException, FileNotFoundException {
        this.parse(new FileInputStream(filename), filename);
    }

    public void parse(InputStream stream, String name) throws HyphenationException {
        InputSource source = new InputSource(stream);
        source.setSystemId(name);
        try {
            this.parser.parse(source);
        }
        catch (FileNotFoundException fnfe) {
            throw new HyphenationException("File not found: " + fnfe.getMessage());
        }
        catch (IOException ioe) {
            throw new HyphenationException(ioe.getMessage());
        }
        catch (SAXException e) {
            throw new HyphenationException(this.errMsg);
        }
    }

    static XMLReader createParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't create XMLReader: " + e.getMessage());
        }
    }

    private String readToken(StringBuilder chars) {
        int countr;
        int i;
        boolean space = false;
        for (i = 0; i < chars.length() && Character.isWhitespace(chars.charAt(i)); ++i) {
            space = true;
        }
        if (space) {
            for (countr = i; countr < chars.length(); ++countr) {
                chars.setCharAt(countr - i, chars.charAt(countr));
            }
            chars.setLength(chars.length() - i);
            if (this.token.length() > 0) {
                String word = this.token.toString();
                this.token.setLength(0);
                return word;
            }
        }
        space = false;
        for (i = 0; i < chars.length(); ++i) {
            if (!Character.isWhitespace(chars.charAt(i))) continue;
            space = true;
            break;
        }
        this.token.append(chars.toString().substring(0, i));
        for (countr = i; countr < chars.length(); ++countr) {
            chars.setCharAt(countr - i, chars.charAt(countr));
        }
        chars.setLength(chars.length() - i);
        if (space) {
            String word = this.token.toString();
            this.token.setLength(0);
            return word;
        }
        this.token.append((CharSequence)chars);
        return null;
    }

    private static String getPattern(String word) {
        StringBuilder pat = new StringBuilder();
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(word.charAt(i))) continue;
            pat.append(word.charAt(i));
        }
        return pat.toString();
    }

    private ArrayList normalizeException(ArrayList ex) {
        ArrayList<Object> res = new ArrayList<Object>();
        for (int i = 0; i < ex.size(); ++i) {
            Object item = ex.get(i);
            if (item instanceof String) {
                String str = (String)item;
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < str.length(); ++j) {
                    char c = str.charAt(j);
                    if (c != this.hyphenChar) {
                        buf.append(c);
                        continue;
                    }
                    res.add(buf.toString());
                    buf.setLength(0);
                    char[] h = new char[]{this.hyphenChar};
                    res.add(new Hyphen(new String(h), null, null));
                }
                if (buf.length() <= 0) continue;
                res.add(buf.toString());
                continue;
            }
            res.add(item);
        }
        return res;
    }

    private String getExceptionWord(ArrayList ex) {
        StringBuilder res = new StringBuilder();
        for (int i = 0; i < ex.size(); ++i) {
            Object item = ex.get(i);
            if (item instanceof String) {
                res.append((String)item);
                continue;
            }
            if (((Hyphen)item).noBreak == null) continue;
            res.append(((Hyphen)item).noBreak);
        }
        return res.toString();
    }

    private static String getInterletterValues(String pat) {
        StringBuilder il = new StringBuilder();
        String word = pat + "a";
        int len = word.length();
        for (int i = 0; i < len; ++i) {
            char c = word.charAt(i);
            if (Character.isDigit(c)) {
                il.append(c);
                ++i;
                continue;
            }
            il.append('0');
        }
        return il.toString();
    }

    protected void getExternalClasses() throws SAXException {
        XMLReader mainParser = this.parser;
        this.parser = PatternParser.createParser();
        this.parser.setContentHandler(this);
        this.parser.setErrorHandler(this);
        InputStream stream = PatternParser.class.getResourceAsStream("classes.xml");
        InputSource source = new InputSource(stream);
        try {
            this.parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe.getMessage());
        }
        finally {
            this.parser = mainParser;
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (local.equals("hyphen-char")) {
            String h = attrs.getValue("value");
            if (h != null && h.length() == 1) {
                this.hyphenChar = h.charAt(0);
            }
        } else if (local.equals("classes")) {
            this.currElement = 1;
        } else if (local.equals("patterns")) {
            if (!this.hasClasses) {
                this.getExternalClasses();
            }
            this.currElement = 3;
        } else if (local.equals("exceptions")) {
            if (!this.hasClasses) {
                this.getExternalClasses();
            }
            this.currElement = 2;
            this.exception = new ArrayList();
        } else if (local.equals("hyphen")) {
            if (this.token.length() > 0) {
                this.exception.add(this.token.toString());
            }
            this.exception.add(new Hyphen(attrs.getValue("pre"), attrs.getValue("no"), attrs.getValue("post")));
            this.currElement = 4;
        }
        this.token.setLength(0);
    }

    @Override
    public void endElement(String uri, String local, String raw) {
        if (this.token.length() > 0) {
            String word = this.token.toString();
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(word), PatternParser.getInterletterValues(word));
                    break;
                }
                case 4: {
                    break;
                }
            }
            if (this.currElement != 4) {
                this.token.setLength(0);
            }
        }
        if (this.currElement == 1) {
            this.hasClasses = true;
        }
        this.currElement = this.currElement == 4 ? 2 : 0;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        StringBuilder chars = new StringBuilder(length);
        chars.append(ch, start, length);
        String word = this.readToken(chars);
        while (word != null) {
            switch (this.currElement) {
                case 1: {
                    this.consumer.addClass(word);
                    break;
                }
                case 2: {
                    this.exception.add(word);
                    this.exception = this.normalizeException(this.exception);
                    this.consumer.addException(this.getExceptionWord(this.exception), (ArrayList)this.exception.clone());
                    this.exception.clear();
                    break;
                }
                case 3: {
                    this.consumer.addPattern(PatternParser.getPattern(word), PatternParser.getInterletterValues(word));
                    break;
                }
            }
            word = this.readToken(chars);
        }
    }

    @Override
    public void warning(SAXParseException ex) {
        this.errMsg = "[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage();
    }

    @Override
    public void error(SAXParseException ex) {
        this.errMsg = "[Error] " + this.getLocationString(ex) + ": " + ex.getMessage();
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.errMsg = "[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage();
        throw ex;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuilder str = new StringBuilder();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }
}

