/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.xobject;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectWrapper;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.filespec.PdfFileSpec;
import com.itextpdf.kernel.pdf.layer.IPdfOCG;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PdfXObject
extends PdfObjectWrapper<PdfStream> {
    protected PdfXObject(PdfStream pdfObject) {
        super(pdfObject);
    }

    public static PdfXObject makeXObject(PdfStream stream) {
        if (PdfName.Form.equals(stream.getAsName(PdfName.Subtype))) {
            return new PdfFormXObject(stream);
        }
        if (PdfName.Image.equals(stream.getAsName(PdfName.Subtype))) {
            return new PdfImageXObject(stream);
        }
        throw new UnsupportedOperationException("Unsupported XObject type.");
    }

    public static Rectangle calculateProportionallyFitRectangleWithWidth(PdfXObject xObject, float x, float y, float width) {
        if (xObject instanceof PdfFormXObject) {
            PdfFormXObject formXObject = (PdfFormXObject)xObject;
            Rectangle bBox = PdfFormXObject.calculateBBoxMultipliedByMatrix(formXObject);
            return new Rectangle(x, y, width, width / bBox.getWidth() * bBox.getHeight());
        }
        if (xObject instanceof PdfImageXObject) {
            PdfImageXObject imageXObject = (PdfImageXObject)xObject;
            return new Rectangle(x, y, width, width / imageXObject.getWidth() * imageXObject.getHeight());
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public static Rectangle calculateProportionallyFitRectangleWithHeight(PdfXObject xObject, float x, float y, float height) {
        if (xObject instanceof PdfFormXObject) {
            PdfFormXObject formXObject = (PdfFormXObject)xObject;
            Rectangle bBox = PdfFormXObject.calculateBBoxMultipliedByMatrix(formXObject);
            return new Rectangle(x, y, height / bBox.getHeight() * bBox.getWidth(), height);
        }
        if (xObject instanceof PdfImageXObject) {
            PdfImageXObject imageXObject = (PdfImageXObject)xObject;
            return new Rectangle(x, y, height / imageXObject.getHeight() * imageXObject.getWidth(), height);
        }
        throw new IllegalArgumentException("PdfFormXObject or PdfImageXObject expected.");
    }

    public void setLayer(IPdfOCG layer) {
        ((PdfStream)this.getPdfObject()).put(PdfName.OC, layer.getIndirectReference());
    }

    public float getWidth() {
        throw new UnsupportedOperationException();
    }

    public float getHeight() {
        throw new UnsupportedOperationException();
    }

    public void addAssociatedFile(PdfFileSpec fs) {
        PdfArray afArray;
        if (null == ((PdfDictionary)fs.getPdfObject()).get(PdfName.AFRelationship)) {
            Logger logger = LoggerFactory.getLogger(PdfXObject.class);
            logger.error("For associated files their associated file specification dictionaries shall include the AFRelationship key.");
        }
        if ((afArray = ((PdfStream)this.getPdfObject()).getAsArray(PdfName.AF)) == null) {
            afArray = new PdfArray();
            ((PdfStream)this.getPdfObject()).put(PdfName.AF, afArray);
        }
        afArray.add((PdfObject)fs.getPdfObject());
    }

    public PdfArray getAssociatedFiles(boolean create) {
        PdfArray afArray = ((PdfStream)this.getPdfObject()).getAsArray(PdfName.AF);
        if (afArray == null && create) {
            afArray = new PdfArray();
            ((PdfStream)this.getPdfObject()).put(PdfName.AF, afArray);
        }
        return afArray;
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return true;
    }
}

