/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.utils.annotationsflattening.IAnnotationFlattener;
import com.itextpdf.kernel.utils.annotationsflattening.PdfAnnotationFlattenFactory;
import java.util.ArrayList;
import java.util.List;

public class PdfAnnotationFlattener {
    private final PdfAnnotationFlattenFactory pdfAnnotationFlattenFactory;

    public PdfAnnotationFlattener(PdfAnnotationFlattenFactory pdfAnnotationFlattenFactory) {
        this.pdfAnnotationFlattenFactory = pdfAnnotationFlattenFactory;
    }

    public PdfAnnotationFlattener() {
        this.pdfAnnotationFlattenFactory = new PdfAnnotationFlattenFactory();
    }

    public List<PdfAnnotation> flatten(List<PdfAnnotation> annotationsToFlatten) {
        if (annotationsToFlatten == null) {
            throw new PdfException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"annotationsToFlatten"}));
        }
        ArrayList<PdfAnnotation> unFlattenedAnnotations = new ArrayList<PdfAnnotation>();
        for (PdfAnnotation pdfAnnotation : annotationsToFlatten) {
            IAnnotationFlattener worker;
            boolean flattenedSuccessfully;
            PdfPage page;
            if (pdfAnnotation == null || (page = pdfAnnotation.getPage()) == null || (flattenedSuccessfully = (worker = this.pdfAnnotationFlattenFactory.getAnnotationFlattenWorker(pdfAnnotation.getSubtype())).flatten(pdfAnnotation, page))) continue;
            unFlattenedAnnotations.add(pdfAnnotation);
        }
        return unFlattenedAnnotations;
    }

    public List<PdfAnnotation> flatten(PdfDocument document) {
        if (document == null) {
            throw new PdfException(MessageFormatUtil.format((String)"{0} should not be null.", (Object[])new Object[]{"document"}));
        }
        ArrayList<PdfAnnotation> annotations = new ArrayList<PdfAnnotation>();
        int documentNumberOfPages = document.getNumberOfPages();
        for (int i = 1; i <= documentNumberOfPages; ++i) {
            PdfPage page = document.getPage(i);
            List<PdfAnnotation> failedFlatteningAnnotations = this.flatten(page.getAnnotations());
            annotations.addAll(failedFlatteningAnnotations);
        }
        return annotations;
    }
}

