/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.statistics;

import com.itextpdf.commons.actions.AbstractStatisticsAggregator;
import com.itextpdf.commons.actions.AbstractStatisticsEvent;
import com.itextpdf.commons.utils.MapUtil;
import com.itextpdf.kernel.pdf.statistics.SizeOfPdfStatisticsEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SizeOfPdfStatisticsAggregator
extends AbstractStatisticsAggregator {
    private static final long MEASURE_COEFFICIENT = 1024L;
    private static final long SIZE_128KB = 131072L;
    private static final long SIZE_1MB = 0x100000L;
    private static final long SIZE_16MB = 0x1000000L;
    private static final long SIZE_128MB = 0x8000000L;
    private static final String STRING_FOR_128KB = "<128kb";
    private static final String STRING_FOR_1MB = "128kb-1mb";
    private static final String STRING_FOR_16MB = "1mb-16mb";
    private static final String STRING_FOR_128MB = "16mb-128mb";
    private static final String STRING_FOR_INF = "128mb+";
    private static final Map<Long, String> DOCUMENT_SIZES;
    private static final List<Long> SORTED_UPPER_BOUNDS_OF_SIZES;
    private final Object lock = new Object();
    private final Map<String, Long> numberOfDocuments = new LinkedHashMap<String, Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void aggregate(AbstractStatisticsEvent event) {
        if (!(event instanceof SizeOfPdfStatisticsEvent)) {
            return;
        }
        long sizeOfPdf = ((SizeOfPdfStatisticsEvent)event).getAmountOfBytes();
        String range = STRING_FOR_INF;
        Object object = SORTED_UPPER_BOUNDS_OF_SIZES.iterator();
        while (object.hasNext()) {
            long upperBound = object.next();
            if (sizeOfPdf > upperBound) continue;
            range = DOCUMENT_SIZES.get(upperBound);
            break;
        }
        object = this.lock;
        synchronized (object) {
            Long documentsOfThisRange = this.numberOfDocuments.get(range);
            Long currentValue = documentsOfThisRange == null ? 1L : documentsOfThisRange + 1L;
            this.numberOfDocuments.put(range, currentValue);
        }
    }

    public Object retrieveAggregation() {
        return Collections.unmodifiableMap(this.numberOfDocuments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AbstractStatisticsAggregator aggregator) {
        if (!(aggregator instanceof SizeOfPdfStatisticsAggregator)) {
            return;
        }
        Map<String, Long> amountOfDocuments = ((SizeOfPdfStatisticsAggregator)aggregator).numberOfDocuments;
        Object object = this.lock;
        synchronized (object) {
            MapUtil.merge(this.numberOfDocuments, amountOfDocuments, (el1, el2) -> {
                if (el2 == null) {
                    return el1;
                }
                return el1 + el2;
            });
        }
    }

    static {
        SORTED_UPPER_BOUNDS_OF_SIZES = Arrays.asList(131072L, 0x100000L, 0x1000000L, 0x8000000L);
        HashMap<Long, String> temp = new HashMap<Long, String>();
        temp.put(131072L, STRING_FOR_128KB);
        temp.put(0x100000L, STRING_FOR_1MB);
        temp.put(0x1000000L, STRING_FOR_16MB);
        temp.put(0x8000000L, STRING_FOR_128MB);
        DOCUMENT_SIZES = Collections.unmodifiableMap(temp);
    }
}

