/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.ocg;

import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.ocg.OCGParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCGRemover {
    public void removeLayers(PdfReader reader, String ... layers) throws IOException {
        int n = reader.getNumberOfPages();
        for (int i = 1; i <= n; ++i) {
            reader.setPageContent(i, reader.getPageContent(i));
        }
        HashSet<String> ocgs = new HashSet<String>();
        for (int i = 0; i < layers.length; ++i) {
            ocgs.add(layers[i]);
        }
        OCGParser parser = new OCGParser(ocgs);
        for (int i = 1; i <= n; ++i) {
            PdfDictionary page = reader.getPageN(i);
            this.parse(parser, page);
            page.remove(new PdfName("PieceInfo"));
            this.removeAnnots(page, ocgs);
            this.removeProperties(page, ocgs);
        }
        PdfDictionary root = reader.getCatalog();
        PdfDictionary ocproperties = root.getAsDict(PdfName.OCPROPERTIES);
        if (ocproperties != null) {
            this.removeOCGsFromArray(ocproperties, PdfName.OCGS, ocgs);
            PdfDictionary d = ocproperties.getAsDict(PdfName.D);
            if (d != null) {
                this.removeOCGsFromArray(d, PdfName.ON, ocgs);
                this.removeOCGsFromArray(d, PdfName.OFF, ocgs);
                this.removeOCGsFromArray(d, PdfName.LOCKED, ocgs);
                this.removeOCGsFromArray(d, PdfName.RBGROUPS, ocgs);
                this.removeOCGsFromArray(d, PdfName.ORDER, ocgs);
                this.removeOCGsFromArray(d, PdfName.AS, ocgs);
            }
        }
        reader.removeUnusedObjects();
    }

    private void removeOCGsFromArray(PdfDictionary dict, PdfName name, Set<String> ocgs) {
        if (dict == null) {
            return;
        }
        PdfArray array = dict.getAsArray(name);
        if (array == null) {
            return;
        }
        this.removeOCGsFromArray(array, ocgs);
    }

    private void removeOCGsFromArray(PdfArray array, Set<String> ocgs) {
        if (array == null) {
            return;
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        int i = array.size();
        while (i > 0) {
            PdfObject o;
            if ((o = array.getDirectObject(--i)).isDictionary()) {
                PdfDictionary dict = (PdfDictionary)o;
                if (this.isToBeRemoved(dict, ocgs)) {
                    remove.add(i);
                } else {
                    this.removeOCGsFromArray(dict, PdfName.OCGS, ocgs);
                }
            }
            if (!o.isArray()) continue;
            this.removeOCGsFromArray((PdfArray)o, ocgs);
        }
        for (Integer i2 : remove) {
            array.remove(i2.intValue());
        }
    }

    private void removeAnnots(PdfDictionary page, Set<String> ocgs) {
        PdfArray annots = page.getAsArray(PdfName.ANNOTS);
        if (annots == null) {
            return;
        }
        ArrayList<Integer> remove = new ArrayList<Integer>();
        int i = annots.size();
        while (i > 0) {
            PdfDictionary annot;
            if (this.isToBeRemoved((annot = annots.getAsDict(--i)).getAsDict(PdfName.OC), ocgs)) {
                remove.add(i);
                continue;
            }
            this.removeOCGsFromArray(annot.getAsDict(PdfName.A), PdfName.STATE, ocgs);
        }
        for (Integer i2 : remove) {
            annots.remove(i2.intValue());
        }
    }

    private void removeProperties(PdfDictionary page, Set<String> ocgs) {
        PdfDictionary resources = page.getAsDict(PdfName.RESOURCES);
        if (resources == null) {
            return;
        }
        PdfDictionary properties = resources.getAsDict(PdfName.PROPERTIES);
        if (properties == null) {
            return;
        }
        Set names = properties.getKeys();
        ArrayList<PdfName> remove = new ArrayList<PdfName>();
        for (PdfName name : names) {
            PdfDictionary dict = properties.getAsDict(name);
            if (this.isToBeRemoved(dict, ocgs)) {
                remove.add(name);
                continue;
            }
            this.removeOCGsFromArray(dict, PdfName.OCGS, ocgs);
        }
        for (PdfName name : remove) {
            properties.remove(name);
        }
    }

    private boolean isToBeRemoved(PdfDictionary ocg, Set<String> names) {
        if (ocg == null) {
            return false;
        }
        PdfString n = ocg.getAsString(PdfName.NAME);
        if (n == null) {
            return false;
        }
        return names.contains(n.toString());
    }

    private void parse(OCGParser parser, PdfDictionary page) throws IOException {
        PRStream stream = (PRStream)page.getAsStream(PdfName.CONTENTS);
        PdfDictionary resources = page.getAsDict(PdfName.RESOURCES);
        parser.parse(stream, resources);
    }
}

