/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.util;

import com.itextpdf.html2pdf.attach.impl.layout.RunningElement;
import com.itextpdf.html2pdf.attach.util.TrimUtil;
import com.itextpdf.html2pdf.css.apply.util.OverflowApplierUtil;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.ListItem;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.renderer.FlexContainerRenderer;
import com.itextpdf.styledxmlparser.util.WhiteSpaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class WaitingInlineElementsHelper {
    private String textTransform;
    private boolean keepLineBreaks;
    private boolean collapseSpaces;
    private List<IElement> waitingLeaves = new ArrayList<IElement>();

    public WaitingInlineElementsHelper(String whiteSpace, String textTransform) {
        this.keepLineBreaks = "pre".equals(whiteSpace) || "pre-wrap".equals(whiteSpace) || "pre-line".equals(whiteSpace);
        this.collapseSpaces = !"pre".equals(whiteSpace) && !"pre-wrap".equals(whiteSpace);
        this.textTransform = textTransform;
    }

    public void add(String text) {
        text = WhiteSpaceUtil.processWhitespaces((String)text, (boolean)this.keepLineBreaks, (boolean)this.collapseSpaces);
        if ("uppercase".equals(this.textTransform)) {
            text = text.toUpperCase();
        } else if ("lowercase".equals(this.textTransform)) {
            text = text.toLowerCase();
        }
        this.waitingLeaves.add((IElement)new Text(text));
    }

    public void add(ILeafElement element) {
        this.waitingLeaves.add((IElement)element);
    }

    public void add(IBlockElement element) {
        this.waitingLeaves.add((IElement)element);
    }

    public void addAll(Collection<ILeafElement> collection) {
        this.waitingLeaves.addAll(collection);
    }

    public void flushHangingLeaves(IPropertyContainer container) {
        Paragraph p = this.createLeavesContainer();
        if (p != null) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("overflow", "visible");
            OverflowApplierUtil.applyOverflow(map, (IPropertyContainer)p);
            if (container instanceof Document) {
                ((Document)container).add((IBlockElement)p);
            } else if (container instanceof Paragraph) {
                for (IElement leafElement : this.waitingLeaves) {
                    if (leafElement instanceof ILeafElement) {
                        ((Paragraph)container).add((ILeafElement)leafElement);
                        continue;
                    }
                    if (!(leafElement instanceof IBlockElement)) continue;
                    ((Paragraph)container).add((IBlockElement)leafElement);
                }
            } else if (((IElement)container).getRenderer() instanceof FlexContainerRenderer) {
                Div div = new Div();
                OverflowApplierUtil.applyOverflow(map, (IPropertyContainer)div);
                div.add((IBlockElement)p);
                ((Div)container).add((IBlockElement)div);
            } else if (container instanceof Div) {
                ((Div)container).add((IBlockElement)p);
            } else if (container instanceof Cell) {
                ((Cell)container).add((IBlockElement)p);
            } else if (container instanceof com.itextpdf.layout.element.List) {
                ListItem li = new ListItem();
                li.add((IBlockElement)p);
                ((com.itextpdf.layout.element.List)container).add(li);
            } else {
                throw new IllegalStateException("Unable to process hanging inline content");
            }
            this.waitingLeaves.clear();
        }
    }

    private Paragraph createLeavesContainer() {
        if (this.collapseSpaces) {
            this.waitingLeaves = TrimUtil.trimLeafElementsAndSanitize(this.waitingLeaves);
        }
        this.capitalize(this.waitingLeaves);
        if (this.waitingLeaves.size() > 0) {
            Paragraph p = this.createParagraphContainer();
            boolean runningElementsOnly = true;
            for (IElement leaf : this.waitingLeaves) {
                if (leaf instanceof ILeafElement) {
                    runningElementsOnly = false;
                    p.add((ILeafElement)leaf);
                    continue;
                }
                if (!(leaf instanceof IBlockElement)) continue;
                runningElementsOnly = runningElementsOnly && leaf instanceof RunningElement;
                p.add((IBlockElement)leaf);
            }
            if (runningElementsOnly) {
                p.getAccessibilityProperties().setRole("Artifact");
            }
            return p;
        }
        return null;
    }

    public Collection<IElement> getWaitingLeaves() {
        return this.waitingLeaves;
    }

    public List<IElement> getSanitizedWaitingLeaves() {
        if (this.collapseSpaces) {
            return TrimUtil.trimLeafElementsAndSanitize(this.waitingLeaves);
        }
        return this.waitingLeaves;
    }

    public void clearWaitingLeaves() {
        this.waitingLeaves.clear();
    }

    public Paragraph createParagraphContainer() {
        return (Paragraph)new Paragraph().setMargin(0.0f);
    }

    private void capitalize(List<IElement> leaves) {
        boolean previousLetter = false;
        boolean previousProcessed = false;
        for (int i = 0; i < leaves.size(); ++i) {
            boolean needCapitalize;
            IElement element = leaves.get(i);
            boolean hasCapitalizeProperty = element.hasOwnProperty(0x100005);
            boolean bl = needCapitalize = hasCapitalizeProperty && (Boolean)element.getOwnProperty(0x100005) != false;
            if (hasCapitalizeProperty && !needCapitalize) {
                previousProcessed = false;
                continue;
            }
            if (element instanceof Text && ("capitalize".equals(this.textTransform) || needCapitalize)) {
                String text = ((Text)element).getText();
                if (!previousProcessed && i > 0) {
                    previousLetter = this.isLastCharAlphabetic(leaves.get(i - 1));
                }
                previousLetter = this.capitalizeAndReturnIsLastAlphabetic((Text)element, text, previousLetter);
                previousProcessed = true;
                continue;
            }
            previousProcessed = false;
            previousLetter = false;
        }
    }

    private boolean isLastCharAlphabetic(IElement element) {
        if (!(element instanceof Text)) {
            return false;
        }
        String text = ((Text)element).getText();
        return text.length() > 0 && Character.isAlphabetic(text.charAt(text.length() - 1));
    }

    private boolean capitalizeAndReturnIsLastAlphabetic(Text element, String text, boolean previousAlphabetic) {
        StringBuilder sb = new StringBuilder();
        boolean previousLetter = previousAlphabetic;
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isLowerCase(text.charAt(i)) && !previousLetter) {
                sb.append(Character.toUpperCase(text.charAt(i)));
                previousLetter = true;
                continue;
            }
            if (Character.isAlphabetic(text.charAt(i))) {
                sb.append(text.charAt(i));
                previousLetter = true;
                continue;
            }
            sb.append(text.charAt(i));
            previousLetter = false;
        }
        element.setText(sb.toString());
        return previousLetter;
    }
}

