/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.html2pdf.attach.wrapelement.SpanWrapper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Text;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.styledxmlparser.node.IElementNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpanTagWorker
implements ITagWorker,
IDisplayAware {
    SpanWrapper spanWrapper;
    Map<IPropertyContainer, String> childrenDisplayMap = new HashMap<IPropertyContainer, String>();
    private List<IPropertyContainer> elements;
    private List<IPropertyContainer> ownLeafElements = new ArrayList<IPropertyContainer>();
    private WaitingInlineElementsHelper inlineHelper;
    private final String display;
    private final String textTransform;

    public SpanTagWorker(IElementNode element, ProcessorContext context) {
        this.spanWrapper = new SpanWrapper();
        Map styles = element.getStyles();
        this.inlineHelper = new WaitingInlineElementsHelper(styles == null ? null : (String)styles.get("white-space"), styles == null ? null : (String)styles.get("text-transform"));
        this.display = styles == null ? null : (String)styles.get("display");
        this.textTransform = styles == null ? null : (String)styles.get("text-transform");
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        if (this.inlineHelper.getWaitingLeaves().isEmpty() && this.spanWrapper.getElements().isEmpty()) {
            this.inlineHelper.add("");
        }
        this.flushInlineHelper();
        this.elements = this.spanWrapper.getElements();
        for (IPropertyContainer elem : this.elements) {
            if (!(elem instanceof IAccessibleElement)) continue;
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)elem, element);
        }
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        IPropertyContainer element = childTagWorker.getElementResult();
        if (element instanceof ILeafElement) {
            this.flushInlineHelper();
            this.spanWrapper.add((ILeafElement)element);
            this.ownLeafElements.add(element);
            return true;
        }
        if (childTagWorker instanceof SpanTagWorker) {
            this.flushInlineHelper();
            this.spanWrapper.add(((SpanTagWorker)childTagWorker).spanWrapper);
            this.childrenDisplayMap.putAll(((SpanTagWorker)childTagWorker).childrenDisplayMap);
            return true;
        }
        if (childTagWorker.getElementResult() instanceof IBlockElement) {
            if (childTagWorker instanceof IDisplayAware) {
                String display = ((IDisplayAware)((Object)childTagWorker)).getDisplay();
                this.childrenDisplayMap.put(childTagWorker.getElementResult(), display);
            }
            this.flushInlineHelper();
            this.spanWrapper.add((IBlockElement)childTagWorker.getElementResult());
            return true;
        }
        return false;
    }

    public List<IPropertyContainer> getAllElements() {
        return this.elements;
    }

    public List<IPropertyContainer> getOwnLeafElements() {
        return this.ownLeafElements;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return null;
    }

    @Override
    public String getDisplay() {
        return this.display;
    }

    String getElementDisplay(IPropertyContainer child) {
        return this.childrenDisplayMap.get(child);
    }

    private void flushInlineHelper() {
        Collection<IElement> waitingLeaves = this.inlineHelper.getWaitingLeaves();
        this.setCapitalizeProperty(waitingLeaves);
        this.spanWrapper.addAll(waitingLeaves);
        this.ownLeafElements.addAll(waitingLeaves);
        this.inlineHelper.clearWaitingLeaves();
    }

    private void setCapitalizeProperty(Collection<IElement> elements) {
        for (IElement iElement : elements) {
            if (!(iElement instanceof Text)) continue;
            if (!iElement.hasOwnProperty(0x100005) && "capitalize".equals(this.textTransform)) {
                iElement.setProperty(0x100005, (Object)true);
                continue;
            }
            iElement.setProperty(0x100005, (Object)false);
        }
    }
}

