/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetMetadataRequest;
import com.ironsoftware.ironpdf.internal.proto.MetadataFieldResult;
import com.ironsoftware.ironpdf.internal.proto.RemoveMetadataRequest;
import com.ironsoftware.ironpdf.internal.proto.SetMetadataRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;

public final class Metadata_Api {
    public static String getAuthor(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Author");
    }

    public static String getMetadata(InternalPdfDocument internalPdfDocument, String key) {
        RpcClient client = Access.ensureConnection();
        GetMetadataRequest.Builder req = GetMetadataRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setKey(key);
        MetadataFieldResult res = client.blockingStub.pdfDocumentMetadataGetMetadata(req.build());
        if (res.getResultOrExceptionCase() == MetadataFieldResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(res.getException());
        }
        return res.getResult().getValue();
    }

    public static void setAuthor(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Author", value);
    }

    public static void setMetadata(InternalPdfDocument internalPdfDocument, String key, String value) {
        RpcClient client = Access.ensureConnection();
        SetMetadataRequest.Builder req = SetMetadataRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setKey(key);
        req.setValue(value);
        EmptyResult res = client.blockingStub.pdfDocumentMetadataSetMetadata(req.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static String getCreationDate(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "CreationDate");
    }

    public static void setCreationDate(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "CreationDate", value);
    }

    public static String getModifiedDate(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "ModDate");
    }

    public static void setModifiedDate(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "ModDate", value);
    }

    public static String getCreator(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Creator");
    }

    public static void setCreator(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Creator", value);
    }

    public static String getKeywords(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Keywords");
    }

    public static void setKeywords(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Keywords", value);
    }

    public static String getProducer(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Producer");
    }

    public static void setProducer(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Producer", value);
    }

    public static String getSubject(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Subject");
    }

    public static void setSubject(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Subject", value);
    }

    public static String getTitle(InternalPdfDocument internalPdfDocument) {
        return Metadata_Api.getMetadata(internalPdfDocument, "Title");
    }

    public static void setTitle(InternalPdfDocument internalPdfDocument, String value) {
        Metadata_Api.setMetadata(internalPdfDocument, "Title", value);
    }

    public static void removeMetadata(InternalPdfDocument internalPdfDocument, String key) {
        RpcClient client = Access.ensureConnection();
        RemoveMetadataRequest.Builder req = RemoveMetadataRequest.newBuilder();
        req.setDocument(internalPdfDocument.remoteDocument);
        req.setKey(key);
        EmptyResult res = client.blockingStub.pdfDocumentMetadataRemoveMetadata(req.build());
        Utils_Util.handleEmptyResult(res);
    }
}

