/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.internal.staticapi;

import com.ironsoftware.ironpdf.bookmark.Bookmark;
import com.ironsoftware.ironpdf.internal.proto.EmptyResult;
import com.ironsoftware.ironpdf.internal.proto.GetBookmarksRequest;
import com.ironsoftware.ironpdf.internal.proto.GetBookmarksResult;
import com.ironsoftware.ironpdf.internal.proto.InsertBookmarkRequest;
import com.ironsoftware.ironpdf.internal.staticapi.Access;
import com.ironsoftware.ironpdf.internal.staticapi.Bookmark_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.Exception_Converter;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import com.ironsoftware.ironpdf.internal.staticapi.RpcClient;
import com.ironsoftware.ironpdf.internal.staticapi.Utils_Util;
import java.util.List;

public final class Bookmark_Api {
    public static List<Bookmark> getBookmarks(InternalPdfDocument internalPdfDocument) {
        RpcClient client = Access.ensureConnection();
        GetBookmarksRequest.Builder request = GetBookmarksRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        GetBookmarksResult result = client.blockingStub.pdfDocumentBookmarkGetBookmarks(request.build());
        if (result.getResultOrExceptionCase() == GetBookmarksResult.ResultOrExceptionCase.EXCEPTION) {
            throw Exception_Converter.fromProto(result.getException());
        }
        return Bookmark_Converter.fromProto(result.getResult());
    }

    public static void insertBookmarkAsFirstChild(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, parentText, null);
    }

    public static void insertBookmark(InternalPdfDocument internalPdfDocument, int pageIndex, String text, String parentText, String previousText) {
        RpcClient client = Access.ensureConnection();
        InsertBookmarkRequest.Builder request = InsertBookmarkRequest.newBuilder();
        request.setDocument(internalPdfDocument.remoteDocument);
        request.setPageIndex(pageIndex);
        request.setText(text);
        if (parentText != null) {
            request.setParentText(parentText);
        }
        if (previousText != null) {
            request.setPreviousText(previousText);
        }
        EmptyResult res = client.blockingStub.pdfDocumentBookmarkInsertBookmark(request.build());
        Utils_Util.handleEmptyResult(res);
    }

    public static void insertBookmarkAtStart(InternalPdfDocument internalPdfDocument, int pageIndex, String text) {
        Bookmark_Api.insertBookmark(internalPdfDocument, pageIndex, text, null, null);
    }
}

