/*
 * Decompiled with CFR 0.152.
 */
package com.ironsoftware.ironpdf.bookmark;

import com.ironsoftware.ironpdf.bookmark.Bookmark;
import com.ironsoftware.ironpdf.internal.staticapi.Bookmark_Api;
import com.ironsoftware.ironpdf.internal.staticapi.InternalPdfDocument;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class BookmarkManager {
    private final InternalPdfDocument internalPdfDocument;

    public BookmarkManager(InternalPdfDocument internalPdfDocument) {
        this.internalPdfDocument = internalPdfDocument;
    }

    public final int getCount() {
        return this.getBookmarks().size();
    }

    public final List<Bookmark> getBookmarks() {
        return Bookmark_Api.getBookmarks(this.internalPdfDocument).stream().peek(x -> x.setBookmarkManager(this)).collect(Collectors.toList());
    }

    public final void addBookMarkAtEnd(String text, int pageIndex) {
        Bookmark lastBookmarks;
        List<Bookmark> bookmarks = this.getBookmarks();
        Bookmark bookmark = lastBookmarks = bookmarks.size() == 0 ? null : bookmarks.get(bookmarks.size() - 1);
        if (lastBookmarks == null) {
            Bookmark_Api.insertBookmarkAtStart(this.internalPdfDocument, pageIndex, text);
        } else {
            Bookmark_Api.insertBookmark(this.internalPdfDocument, pageIndex, text, lastBookmarks.getParentBookmarkText(), lastBookmarks.getText());
        }
    }

    public final void addBookMarkAtStart(String text, int pageIndex) {
        List<Bookmark> bookmarks = this.getBookmarks();
        Bookmark firstBookmarks = bookmarks.size() == 0 ? null : bookmarks.get(0);
        Bookmark_Api.insertBookmarkAtStart(this.internalPdfDocument, pageIndex, text);
    }

    public final void insertBookmark(String text, int pageIndex, String parentText, String previousText) {
        Bookmark_Api.insertBookmark(this.internalPdfDocument, pageIndex, text, parentText, previousText);
    }

    public final void insertBookmark(Bookmark bookmark) {
        Bookmark_Api.insertBookmark(this.internalPdfDocument, bookmark.getPageIndex(), bookmark.getText(), bookmark.getParentBookmarkText(), bookmark.getPreviousBookmarkText());
    }

    public final Bookmark addChildBookmark(String text, int pageIndex, String parentBookmarkText) {
        Bookmark_Api.insertBookmark(this.internalPdfDocument, pageIndex, text, parentBookmarkText, null);
        Optional<Bookmark> optNewBookmark = Bookmark_Api.getBookmarks(this.internalPdfDocument).stream().filter(x -> x.getText().equals(text) && x.getPageIndex() == pageIndex && x.getParentBookmarkText().equals(parentBookmarkText)).findFirst();
        optNewBookmark.ifPresent(x -> x.setBookmarkManager(this));
        return optNewBookmark.orElse(null);
    }
}

