/*
 * Decompiled with CFR 0.152.
 */
package com.iqiyi.android.qigsaw.core.splitrequest.splitinfo;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.iqiyi.android.qigsaw.core.common.AbiUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SplitInfo {
    private final String splitName;
    private final String splitVersion;
    private final String appVersion;
    private final boolean builtIn;
    private final int dexNumber;
    private final boolean isMultiDex;
    private final int minSdkVersion;
    private final List<String> workProcesses;
    private final List<String> dependencies;
    private final List<ApkData> apkDataList;
    private final List<LibData> libDataList;
    private AtomicReference<LibData> primaryLibData = new AtomicReference();
    private List<ApkData> primaryApkDataList;

    SplitInfo(String splitName, String appVersion, String version, boolean builtIn, int minSdkVersion, int dexNumber, List<String> workProcesses, List<String> dependencies, List<ApkData> apkDataList, List<LibData> libDataList) {
        this.splitName = splitName;
        this.appVersion = appVersion;
        this.splitVersion = version;
        this.builtIn = builtIn;
        this.minSdkVersion = minSdkVersion;
        this.isMultiDex = dexNumber > 1;
        this.dexNumber = dexNumber;
        this.workProcesses = workProcesses;
        this.dependencies = dependencies;
        this.apkDataList = apkDataList;
        this.libDataList = libDataList;
    }

    public String getSplitName() {
        return this.splitName;
    }

    public synchronized List<ApkData> getApkDataList(Context context) throws IOException {
        if (this.primaryApkDataList != null) {
            return this.primaryApkDataList;
        }
        this.primaryApkDataList = new ArrayList<ApkData>();
        LibData primaryAbi = this.getPrimaryLibData(context);
        for (ApkData apkData : this.apkDataList) {
            if (apkData.abi.equals("master")) {
                this.primaryApkDataList.add(apkData);
            }
            if (primaryAbi == null || !primaryAbi.abi.equals(apkData.abi)) continue;
            this.primaryApkDataList.add(apkData);
        }
        if (primaryAbi != null && this.primaryApkDataList.size() <= 1) {
            throw new RuntimeException("Unable to find split config apk for abi" + primaryAbi.abi);
        }
        return this.primaryApkDataList;
    }

    public String obtainInstalledMark(Context context) throws IOException {
        List<ApkData> apkDataList = this.getApkDataList(context);
        String markStart = null;
        long markEnd = 0L;
        for (ApkData apkData : apkDataList) {
            if ("master".equals(apkData.getAbi())) {
                markStart = apkData.md5;
                continue;
            }
            markEnd = apkData.size;
        }
        return markStart + "." + markEnd;
    }

    public long getApkTotalSize(Context context) throws IOException {
        List<ApkData> apkDataList = this.getApkDataList(context);
        long totalSize = 0L;
        for (ApkData apkData : apkDataList) {
            totalSize += apkData.size;
        }
        return totalSize;
    }

    public ApkData getApkDataForMaster() {
        for (ApkData apkData : this.apkDataList) {
            if (!apkData.abi.equals("master")) continue;
            return apkData;
        }
        throw new RuntimeException("Unable to find master apk for " + this.splitName);
    }

    public String getSplitVersion() {
        return this.splitVersion;
    }

    public boolean isBuiltIn() {
        return this.builtIn;
    }

    @Nullable
    public LibData getPrimaryLibData(Context context) throws IOException {
        if (this.primaryLibData.get() != null) {
            return this.primaryLibData.get();
        }
        String baseAbi = AbiUtil.getBasePrimaryAbi((Context)context);
        if (this.libDataList == null) {
            return null;
        }
        ArrayList<String> splitABIs = new ArrayList<String>();
        for (LibData libData : this.libDataList) {
            splitABIs.add(libData.abi);
        }
        String splitPrimaryAbi = AbiUtil.findSplitPrimaryAbi((String)baseAbi, splitABIs);
        if (splitPrimaryAbi == null) {
            throw new IOException("No supported abi for split " + this.splitName);
        }
        for (LibData libData : this.libDataList) {
            if (!libData.abi.equals(splitPrimaryAbi)) continue;
            this.primaryLibData.compareAndSet(null, libData);
            break;
        }
        return this.primaryLibData.get();
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public boolean isMultiDex() {
        return this.isMultiDex;
    }

    public boolean hasDex() {
        return this.dexNumber > 0;
    }

    public List<String> getWorkProcesses() {
        return this.workProcesses;
    }

    public int getMinSdkVersion() {
        return this.minSdkVersion;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public static class LibData {
        private final String abi;
        private final List<Lib> libs;

        LibData(String abi, List<Lib> libs) {
            this.abi = abi;
            this.libs = libs;
        }

        public String getAbi() {
            return this.abi;
        }

        public List<Lib> getLibs() {
            return this.libs;
        }

        public static class Lib {
            private final String name;
            private final String md5;
            private final long size;

            Lib(String name, String md5, long size) {
                this.name = name;
                this.md5 = md5;
                this.size = size;
            }

            public String getName() {
                return this.name;
            }

            public String getMd5() {
                return this.md5;
            }

            public long getSize() {
                return this.size;
            }
        }
    }

    public static class ApkData {
        private String abi;
        private String url;
        private String md5;
        private long size;

        ApkData(String abi, String url, String md5, long size) {
            this.abi = abi;
            this.url = url;
            this.md5 = md5;
            this.size = size;
        }

        public String getAbi() {
            return this.abi;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMd5() {
            return this.md5;
        }

        public long getSize() {
            return this.size;
        }
    }
}

