/*
 * Decompiled with CFR 0.152.
 */
package com.io.tools.android.ramiloif.folderchooser;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;
import com.io.tools.android.ramiloif.folderchooser.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChooseDirectoryDialog
extends AlertDialog {
    private TextView mFolderNameTV;
    private boolean mChoosed = false;
    private CheckBox mShowAgainCHB;
    private RecyclerView.Adapter mAdapter;
    private String mOkText = "Choose Folder";
    private String mCancelText = "Cancel";
    private String mTitleText = "Pick Folder";
    private File startDir = Environment.getExternalStorageDirectory();
    private File mSelectedDir;
    private DirectoryChooseListener mListener;
    private final List<File> mFilesList = new ArrayList<File>();
    private String mNeverAskAgainText = "Never ask again";
    private boolean mShowNeverAskAgain = false;

    public static ChooseDirectoryDialogBuilder builder(Context context) {
        return new ChooseDirectoryDialogBuilder(context);
    }

    public ChooseDirectoryDialog(@NonNull Context context) {
        super(context);
    }

    public ChooseDirectoryDialog setOKText(String text) {
        this.mOkText = text;
        return this;
    }

    public ChooseDirectoryDialog setCancelText(String text) {
        this.mCancelText = text;
        return this;
    }

    public ChooseDirectoryDialog setTitleText(String text) {
        this.mTitleText = text;
        return this;
    }

    public ChooseDirectoryDialog setStartDir(File dir) {
        this.startDir = dir;
        return this;
    }

    public ChooseDirectoryDialog setOnPickListener(DirectoryChooseListener listener) {
        this.mListener = listener;
        return this;
    }

    public ChooseDirectoryDialog setNeverAskAgainText(String mNeverAskAgainText) {
        this.mNeverAskAgainText = mNeverAskAgainText;
        return this;
    }

    public ChooseDirectoryDialog showNeverAskAgain(boolean isShow) {
        this.mShowNeverAskAgain = isShow;
        return this;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_choose_directory);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.file_folder_recycler);
        ((TextView)this.findViewById(R.id.title)).setText((CharSequence)this.mTitleText);
        this.mFolderNameTV = (TextView)this.findViewById(R.id.folder_name);
        if (this.mShowNeverAskAgain) {
            this.mShowAgainCHB = (CheckBox)this.findViewById(R.id.checkbox);
            this.mShowAgainCHB.setText((CharSequence)this.mNeverAskAgainText);
            this.mShowAgainCHB.setVisibility(0);
        }
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = this.createAdapter();
        Button mPositiveButton = (Button)this.findViewById(R.id.positive_button);
        Button mNegativeButton = (Button)this.findViewById(R.id.negative_button);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (!ChooseDirectoryDialog.this.mChoosed) {
                    ChooseDirectoryDialog.this.mListener.onCancel();
                }
            }
        });
        mNegativeButton.setText((CharSequence)this.mCancelText);
        mNegativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseDirectoryDialog.this.dismiss();
            }
        });
        mPositiveButton.setText((CharSequence)this.mOkText);
        mPositiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseDirectoryDialog.this.mChoosed = true;
                ChooseDirectoryDialog.this.dismiss();
                DialogResult result = new DialogResult();
                result.mPath = ChooseDirectoryDialog.this.mSelectedDir.getAbsolutePath();
                if (ChooseDirectoryDialog.this.mShowNeverAskAgain) {
                    result.mAskAgain = ChooseDirectoryDialog.this.mShowAgainCHB.isChecked();
                }
                ChooseDirectoryDialog.this.mListener.onDirectoryPicked(result);
            }
        });
        recyclerView.setAdapter(this.mAdapter);
        this.walkToDir(this.startDir);
    }

    public void onBackPressed() {
        if (this.mSelectedDir.equals(this.startDir)) {
            super.onBackPressed();
        } else {
            this.mSelectedDir = this.mSelectedDir.getParentFile();
            this.walkToDir(this.mSelectedDir);
        }
    }

    private RecyclerView.Adapter createAdapter() {
        return new RecyclerView.Adapter<FileVH>(){

            public FileVH onCreateViewHolder(ViewGroup parent, int viewType) {
                View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_file, parent, false);
                return new FileVH(v);
            }

            public void onBindViewHolder(FileVH holder, int position) {
                final File file = (File)ChooseDirectoryDialog.this.mFilesList.get(position);
                if (file.isDirectory()) {
                    holder.mFileImage.setImageResource(R.drawable.ic_folder_black_48dp);
                } else {
                    holder.mFileImage.setImageResource(R.drawable.ic_insert_drive_file_black_36dp);
                }
                holder.mFileText.setText((CharSequence)file.getName());
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (file.isDirectory()) {
                            ChooseDirectoryDialog.this.walkToDir(file);
                        }
                    }
                });
            }

            public int getItemCount() {
                return ChooseDirectoryDialog.this.mFilesList.size();
            }
        };
    }

    private void walkToDir(File file) {
        this.mFilesList.clear();
        this.mFilesList.addAll(Arrays.asList(file.listFiles()));
        this.mSelectedDir = file;
        this.mAdapter.notifyDataSetChanged();
        this.mFolderNameTV.setText(this.buildTitleText());
    }

    private CharSequence buildTitleText() {
        return this.mSelectedDir.getName();
    }

    private class FileVH
    extends RecyclerView.ViewHolder {
        ImageView mFileImage;
        TextView mFileText;

        FileVH(View itemView) {
            super(itemView);
            this.mFileImage = (ImageView)itemView.findViewById(R.id.file_icon);
            this.mFileText = (TextView)itemView.findViewById(R.id.file_text);
        }
    }

    public static interface DirectoryChooseListener {
        public void onDirectoryPicked(DialogResult var1);

        public void onCancel();
    }

    public class DialogResult {
        private String mPath;
        private boolean mAskAgain;

        public String getPath() {
            return this.mPath;
        }

        public boolean isAskAgain() {
            return this.mAskAgain;
        }
    }

    public static class ChooseDirectoryDialogBuilder {
        ChooseDirectoryDialog mDialog;

        public ChooseDirectoryDialogBuilder(Context context) {
            this.mDialog = new ChooseDirectoryDialog(context);
        }

        public ChooseDirectoryDialogBuilder okText(String text) {
            this.mDialog.mOkText = text;
            return this;
        }

        public ChooseDirectoryDialogBuilder cancelText(String text) {
            this.mDialog.mCancelText = text;
            return this;
        }

        public ChooseDirectoryDialogBuilder titleText(String text) {
            this.mDialog.mTitleText = text;
            return this;
        }

        public ChooseDirectoryDialogBuilder startDir(File dir) {
            this.mDialog.startDir = dir;
            return this;
        }

        public ChooseDirectoryDialogBuilder onPickListener(DirectoryChooseListener listener) {
            this.mDialog.mListener = listener;
            return this;
        }

        public ChooseDirectoryDialogBuilder neverAskAgainText(String mNeverAskAgainText) {
            this.mDialog.mNeverAskAgainText = mNeverAskAgainText;
            return this;
        }

        public ChooseDirectoryDialogBuilder showNeverAskAgain(boolean isShow) {
            this.mDialog.mShowNeverAskAgain = isShow;
            return this;
        }

        public ChooseDirectoryDialog build() {
            return this.mDialog;
        }
    }
}

