/*
 * Decompiled with CFR 0.152.
 */
package com.io.tools.android.ramiloif.folderchooser;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.v7.app.AlertDialog;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.io.tools.android.ramiloif.folderchooser.R;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChooseDirectoryDialog
extends AlertDialog {
    private TextView mTitleTV;
    private boolean mChoosed = false;
    private RecyclerView.Adapter mAdapter;
    private String mOkText = "Choose Folder";
    private String mCancelText = "Cancel";
    private String mTitleText = "Pick";
    private File startDir = Environment.getExternalStorageDirectory();
    private File mSelectedDir;
    private DirectoryChooseListener mListener;
    private final List<File> mFilesList = new ArrayList<File>();

    public ChooseDirectoryDialog(@NonNull Context context) {
        super(context);
    }

    public ChooseDirectoryDialog setOKText(String text) {
        this.mOkText = text;
        return this;
    }

    public ChooseDirectoryDialog setmCancelText(String text) {
        this.mCancelText = text;
        return this;
    }

    public ChooseDirectoryDialog setmTitleText(String text) {
        this.mTitleText = text;
        return this;
    }

    public ChooseDirectoryDialog setStartDir(File dir) {
        this.startDir = dir;
        return this;
    }

    public ChooseDirectoryDialog setOnPickListener(DirectoryChooseListener listener) {
        this.mListener = listener;
        return this;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dialog_choose_directory);
        RecyclerView recyclerView = (RecyclerView)this.findViewById(R.id.file_folder_recycler);
        this.mTitleTV = (TextView)this.findViewById(R.id.choose_title);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = this.createAdapter();
        Button mPositiveButton = (Button)this.findViewById(R.id.positive_button);
        Button mNegativeButton = (Button)this.findViewById(R.id.negative_button);
        this.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                if (!ChooseDirectoryDialog.this.mChoosed) {
                    ChooseDirectoryDialog.this.mListener.onCancel();
                }
            }
        });
        mNegativeButton.setText((CharSequence)this.mCancelText);
        mNegativeButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseDirectoryDialog.this.dismiss();
            }
        });
        mPositiveButton.setText((CharSequence)this.mOkText);
        mPositiveButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ChooseDirectoryDialog.this.mChoosed = true;
                ChooseDirectoryDialog.this.dismiss();
                ChooseDirectoryDialog.this.mListener.onDirectoryPicked(ChooseDirectoryDialog.this.mSelectedDir.getAbsolutePath());
            }
        });
        recyclerView.setAdapter(this.mAdapter);
        this.walkToDir(this.startDir);
    }

    public void onBackPressed() {
        if (this.mSelectedDir.equals(this.startDir)) {
            super.onBackPressed();
        } else {
            this.mSelectedDir = this.mSelectedDir.getParentFile();
            this.walkToDir(this.mSelectedDir);
        }
    }

    private RecyclerView.Adapter createAdapter() {
        return new RecyclerView.Adapter<FileVH>(){

            public FileVH onCreateViewHolder(ViewGroup parent, int viewType) {
                View v = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_file, parent, false);
                return new FileVH(v);
            }

            public void onBindViewHolder(FileVH holder, int position) {
                final File file = (File)ChooseDirectoryDialog.this.mFilesList.get(position);
                if (file.isDirectory()) {
                    holder.mFileImage.setImageResource(R.drawable.ic_folder_black_48dp);
                } else {
                    holder.mFileImage.setImageResource(R.drawable.ic_insert_drive_file_black_36dp);
                }
                holder.mFileText.setText((CharSequence)file.getName());
                holder.itemView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (file.isDirectory()) {
                            ChooseDirectoryDialog.this.walkToDir(file);
                        }
                    }
                });
            }

            public int getItemCount() {
                return ChooseDirectoryDialog.this.mFilesList.size();
            }
        };
    }

    private void walkToDir(File file) {
        this.mFilesList.clear();
        this.mFilesList.addAll(Arrays.asList(file.listFiles()));
        this.mSelectedDir = file;
        this.mAdapter.notifyDataSetChanged();
        this.mTitleTV.setText(this.buildTitleText());
    }

    private CharSequence buildTitleText() {
        return this.mSelectedDir.getName();
    }

    private class FileVH
    extends RecyclerView.ViewHolder {
        ImageView mFileImage;
        TextView mFileText;

        FileVH(View itemView) {
            super(itemView);
            this.mFileImage = (ImageView)itemView.findViewById(R.id.file_icon);
            this.mFileText = (TextView)itemView.findViewById(R.id.file_text);
        }
    }

    public static interface DirectoryChooseListener {
        public void onDirectoryPicked(String var1);

        public void onCancel();
    }
}

