/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.hmac;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.primeframework.jwt.Signer;
import org.primeframework.jwt.domain.Algorithm;

public class HMACSigner
implements Signer {
    private final Algorithm algorithm;
    private byte[] secret;

    private HMACSigner(Algorithm algorithm, String secret) {
        this.algorithm = algorithm;
        this.secret = secret.getBytes();
    }

    public static HMACSigner newSHA256Signer(String secret) {
        return new HMACSigner(Algorithm.HS256, secret);
    }

    public static HMACSigner newSHA384Signer(String secret) {
        return new HMACSigner(Algorithm.HS384, secret);
    }

    public static HMACSigner newSHA512Signer(String secret) {
        return new HMACSigner(Algorithm.HS512, secret);
    }

    @Override
    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public byte[] sign(String message) {
        Objects.requireNonNull(this.algorithm);
        Objects.requireNonNull(this.secret);
        try {
            Mac mac = Mac.getInstance(this.algorithm.getName());
            mac.init(new SecretKeySpec(this.secret, this.algorithm.getName()));
            return mac.doFinal(message.getBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

