/*
 * Decompiled with CFR 0.152.
 */
package org.primeframework.jwt.domain;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.primeframework.jwt.JWTDecoder;
import org.primeframework.jwt.JWTEncoder;

public class JWT {
    @JsonProperty(value="aud")
    public Object audience;
    @JsonIgnore
    public Map<String, Object> claims = new LinkedHashMap<String, Object>();
    @JsonProperty(value="exp")
    public ZonedDateTime expiration;
    @JsonProperty(value="iat")
    public ZonedDateTime issuedAt;
    @JsonProperty(value="iss")
    public String issuer;
    @JsonProperty(value="nbf")
    public ZonedDateTime notBefore;
    @JsonProperty(value="sub")
    public String subject;
    @JsonProperty(value="jti")
    public String uniqueId;

    public static JWTDecoder getDecoder() {
        return JWTDecoder.getInstance();
    }

    public static JWTEncoder getEncoder() {
        return JWTEncoder.getInstance();
    }

    @JsonAnySetter
    public JWT addClaim(String name, Object value) {
        if (value != null) {
            this.claims.put(name, value);
        }
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> anyGetter() {
        return this.claims;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JWT jwt = (JWT)o;
        return Objects.equals(this.audience, jwt.audience) && Objects.equals(this.claims, jwt.claims) && Objects.equals(this.expiration, jwt.expiration) && Objects.equals(this.issuedAt, jwt.issuedAt) && Objects.equals(this.issuer, jwt.issuer) && Objects.equals(this.notBefore, jwt.notBefore) && Objects.equals(this.subject, jwt.subject) && Objects.equals(this.uniqueId, jwt.uniqueId);
    }

    public Boolean getBoolean(String key) {
        Object object = this.claims.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return (Boolean)object;
    }

    public Integer getInteger(String key) {
        Object object = this.claims.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return Integer.parseInt((String)object);
        }
        return (Integer)object;
    }

    public List<String> getList(String key) {
        Object object = this.claims.get(key);
        if (object == null) {
            return null;
        }
        return (List)object;
    }

    public Long getLong(String key) {
        Object object = this.claims.get(key);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof Integer) {
            return ((Integer)object).longValue();
        }
        return (Long)object;
    }

    public Object getObject(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("aud")) {
            return this.audience;
        }
        return this.claims.get(key);
    }

    @JsonIgnore
    public Map<String, Object> getRawClaims() {
        HashMap<String, Object> rawClaims = new HashMap<String, Object>(this.claims);
        if (this.audience != null) {
            rawClaims.put("aud", this.audience);
        }
        if (this.expiration != null) {
            rawClaims.put("exp", this.expiration.toEpochSecond());
        }
        if (this.issuedAt != null) {
            rawClaims.put("iat", this.issuedAt.toEpochSecond());
        }
        if (this.issuer != null) {
            rawClaims.put("iss", this.issuer);
        }
        if (this.notBefore != null) {
            rawClaims.put("nbf", this.notBefore.toEpochSecond());
        }
        if (this.subject != null) {
            rawClaims.put("sub", this.subject);
        }
        if (this.uniqueId != null) {
            rawClaims.put("jti", this.uniqueId);
        }
        return rawClaims;
    }

    public String getString(String key) {
        if (key == null) {
            return null;
        }
        if (key.equals("sub")) {
            return this.subject;
        }
        if (key.equals("jti")) {
            return this.uniqueId;
        }
        if (key.equals("iss")) {
            return this.issuer;
        }
        return (String)this.claims.get(key);
    }

    public int hashCode() {
        return Objects.hash(this.audience, this.claims, this.expiration, this.issuedAt, this.issuer, this.notBefore, this.subject, this.uniqueId);
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.expiration != null && this.expiration.isBefore(ZonedDateTime.now(ZoneOffset.UTC));
    }

    @JsonIgnore
    public boolean isUnavailableForProcessing() {
        return this.notBefore != null && this.notBefore.isAfter(ZonedDateTime.now(ZoneOffset.UTC));
    }

    public JWT setAudience(Object audience) {
        this.audience = audience;
        return this;
    }

    public JWT setExpiration(ZonedDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    public JWT setIssuedAt(ZonedDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public JWT setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public JWT setNotBefore(ZonedDateTime notBefore) {
        this.notBefore = notBefore;
        return this;
    }

    public JWT setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public JWT setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }
}

