/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.netty.WebSocketClientHandler;
import com.intuit.karate.netty.WebSocketListener;
import com.intuit.karate.netty.WebSocketOptions;
import io.netty.karate.channel.ChannelInitializer;
import io.netty.karate.channel.ChannelPipeline;
import io.netty.karate.channel.socket.SocketChannel;
import io.netty.karate.handler.codec.http.DefaultHttpHeaders;
import io.netty.karate.handler.codec.http.HttpClientCodec;
import io.netty.karate.handler.codec.http.HttpObjectAggregator;
import io.netty.karate.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.karate.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.karate.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.karate.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.karate.handler.ssl.SslContext;
import io.netty.karate.handler.ssl.SslContextBuilder;
import io.netty.karate.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.util.Map;
import javax.net.ssl.SSLException;

public class WebSocketClientInitializer
extends ChannelInitializer<SocketChannel> {
    private final URI uri;
    private final int port;
    private final SslContext sslContext;
    private final WebSocketClientHandler handler;

    public WebSocketClientInitializer(WebSocketOptions options, WebSocketListener listener) {
        this.uri = options.getUri();
        this.port = options.getPort();
        if (options.isSsl()) {
            try {
                this.sslContext = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.sslContext = null;
        }
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        Map<String, Object> headers = options.getHeaders();
        if (headers != null) {
            headers.forEach((k, v) -> nettyHeaders.add((String)k, v));
        }
        WebSocketClientHandshaker handShaker = WebSocketClientHandshakerFactory.newHandshaker(this.uri, WebSocketVersion.V13, options.getSubProtocol(), true, nettyHeaders, options.getMaxPayloadSize());
        this.handler = new WebSocketClientHandler(handShaker, listener);
    }

    @Override
    protected void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline p = ch.pipeline();
        if (this.sslContext != null) {
            p.addLast(this.sslContext.newHandler(ch.alloc(), this.uri.getHost(), this.port));
        }
        p.addLast(new HttpClientCodec());
        p.addLast(new HttpObjectAggregator(8192));
        p.addLast(WebSocketClientCompressionHandler.INSTANCE);
        p.addLast(this.handler);
    }

    public WebSocketClientHandler getHandler() {
        return this.handler;
    }
}

