/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.netty;

import com.intuit.karate.core.Feature;
import com.intuit.karate.core.FeatureBackend;
import com.intuit.karate.core.FeatureParser;
import com.intuit.karate.netty.FeatureServerHandler;
import io.netty.karate.channel.ChannelInitializer;
import io.netty.karate.channel.ChannelPipeline;
import io.netty.karate.channel.socket.SocketChannel;
import io.netty.karate.handler.codec.http.HttpObjectAggregator;
import io.netty.karate.handler.codec.http.HttpServerCodec;
import io.netty.karate.handler.ssl.SslContext;
import java.io.File;
import java.util.Map;

public class FeatureServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;
    private final FeatureBackend backend;
    private final Runnable stopFunction;

    public FeatureServerInitializer(SslContext sslCtx, File featureFile, Map<String, Object> vars, Runnable stopFunction) {
        this.sslCtx = sslCtx;
        Feature feature = FeatureParser.parse(featureFile);
        this.backend = new FeatureBackend(feature, vars);
        this.stopFunction = stopFunction;
    }

    @Override
    public void initChannel(SocketChannel ch) {
        ChannelPipeline p = ch.pipeline();
        if (this.sslCtx != null) {
            p.addLast(this.sslCtx.newHandler(ch.alloc()));
        }
        p.addLast(new HttpServerCodec());
        p.addLast(new HttpObjectAggregator(0x100000));
        p.addLast(new FeatureServerHandler(this.backend, this.sslCtx != null, this.stopFunction));
    }
}

