/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.selenium;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.validator.RegexValidator;
import java.util.HashMap;
import java.util.Map;

public class TestCommand {
    private String id;
    private String comment;
    private String command;
    private String target;
    private String value;
    private static final RegexValidator urlValidator = new RegexValidator("^(https?|file)://*");

    TestCommand(Map<String, Object> commandJson) {
        this.id = this.get("id", commandJson);
        this.comment = this.get("comment", commandJson);
        this.command = this.get("command", commandJson);
        this.target = this.get("target", commandJson);
        this.value = this.get("value", commandJson);
    }

    public String convert(String url, HashMap<String, String> variables) {
        this.target = this.preProcess(this.target, variables);
        this.value = this.preProcess(this.value, variables);
        StringBuilder sb = new StringBuilder("\n# ").append(this.toString()).append("\n");
        if ("open".equals(this.command)) {
            String commandUrl = url;
            commandUrl = urlValidator.validate(new ScriptValue(this.target)).isPass() ? this.target : this.getUrlFromBaseAndPath(commandUrl, this.target);
            this.emitOpen(sb, commandUrl);
        } else if ("clickAt".equals(this.command) || "click".equals(this.command) || "clickAndWait".equals(this.command)) {
            this.emitClick(sb);
        } else if ("verifyText".equals(this.command) || "assertText".equals(this.command)) {
            this.emitVerifyText(sb);
        } else if ("verifyTitle".equals(this.command) || "assertTitle".equals(this.command)) {
            this.emitVerifyTitle(sb);
        } else if ("type".equals(this.command) || "sendKeys".equals(this.command)) {
            this.emitSendKeys(sb);
        } else if ("store".equals(this.command)) {
            variables.put("${" + this.value + '}', this.target);
        } else if ("echo".equals(this.command)) {
            this.emitEcho(sb);
        } else if ("pause".equals(this.command)) {
            this.emitPause(sb);
        }
        return sb.toString();
    }

    public String toString() {
        return "# TestCommand{id='" + this.id + '\'' + ", comment='" + this.comment + '\'' + ", command='" + this.command + '\'' + ", target='" + this.target + '\'' + ", value='" + this.value + '\'' + '}';
    }

    private String get(String key, Map<String, Object> map) {
        String val = (String)map.get(key);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    private String getUrlFromBaseAndPath(String base, String path) {
        if (base.endsWith("/")) {
            base = base.substring(0, base.length() - 1);
        }
        return path.startsWith("/") ? base + path : base + '/' + path;
    }

    private void emitOpen(StringBuilder sb, String url) {
        this.appendGivenUrl(sb, "url");
        this.appendRequestParams(sb, "url", url);
        this.appendWhenThen(sb);
    }

    private void emitEcho(StringBuilder sb) {
        sb.append("* print ").append(this.target).append('\n');
    }

    private void emitPause(StringBuilder sb) {
        sb.append("* def sleep = function(pause){ java.lang.Thread.sleep(pause) }\n").append("* sleep(").append(this.target).append(")\n");
    }

    private void emitClick(StringBuilder sb) {
        this.emitFindElement(sb);
        this.appendGivenUrl(sb, "element/' + webdriverElementId + '/click");
        sb.append("And request {}\n");
        this.appendWhenThen(sb);
    }

    private void emitVerifyText(StringBuilder sb) {
        this.emitFindElement(sb);
        this.appendGivenUrl(sb, "element/' + webdriverElementId + '/text");
        this.appendWhenThen(sb, "GET");
        sb.append("* def ").append("pageTitle").append(" = response.value\n").append("* print 'Page Title is 'pageTitle").append('\n').append(this.getAssertion("pageTitle", this.target));
    }

    private void emitVerifyTitle(StringBuilder sb) {
        this.appendGivenUrl(sb, "title");
        this.appendWhenThen(sb, "GET");
        sb.append("* def ").append("pageTitle").append(" = response.value\n").append("* print 'Page Title is 'pageTitle").append('\n').append(this.getAssertion("pageTitle", this.target));
    }

    private void emitSendKeys(StringBuilder sb) {
        this.emitFindElement(sb);
        this.appendGivenUrl(sb, "element/' + webdriverElementId + '/value");
        this.appendRequestParamsAsArray(sb, "value", this.value);
        this.appendWhenThen(sb);
    }

    private void emitFindElement(StringBuilder sb) {
        String[] tokens = this.target.split("=");
        String using = tokens[0];
        String value = tokens[1];
        if (this.target.startsWith("//")) {
            using = "xpath";
            value = this.target;
        } else {
            using = this.getLocateBy(using);
        }
        this.appendGivenUrl(sb, "element");
        this.appendRequestParams(sb, "using", using, "value", value);
        this.appendWhenThen(sb);
        sb.append("* def ").append("webdriverElementId").append(" = response.value.ELEMENT\n").append("* print 'Element ID is 'webdriverElementId").append("\n");
    }

    private void appendGivenUrl(StringBuilder sb, String path) {
        sb.append("Given url ").append("session.url").append(" + '/").append(path).append("'\n");
    }

    private void appendWhenThen(StringBuilder sb) {
        this.appendWhenThen(sb, "POST");
    }

    private void appendWhenThen(StringBuilder sb, String method) {
        sb.append("When method ").append(method).append("\nThen status 200\n").append("And assert response.status == 0\n");
    }

    private void appendRequestParams(StringBuilder sb, String key, String value) {
        value = value.replace("'", "\"");
        sb.append("And request {").append(key).append(":'").append(value).append("'}\n");
    }

    private void appendRequestParamsAsArray(StringBuilder sb, String key, String value) {
        value = value.replace("'", "\"");
        sb.append("And request {").append(key).append(":['").append(value).append("']}\n");
    }

    private void appendRequestParams(StringBuilder sb, String key1, String value1, String key2, String value2) {
        value1 = value1.replace("'", "\"");
        value2 = value2.replace("'", "\"");
        sb.append("And request {").append(key1).append(":'").append(value1).append("', ").append(key2).append(":'").append(value2).append("'}\n");
    }

    private String preProcess(String param, HashMap<String, String> variables) {
        if (param != null) {
            StringBuilder sb = new StringBuilder(param);
            for (String var : variables.keySet()) {
                int index = sb.indexOf(var);
                if (index < 0) continue;
                sb.replace(index, index + var.length(), variables.get(var));
            }
            param = sb.toString();
        }
        return param;
    }

    private String getAssertion(String varName, String expectedValue) {
        return "* assert " + varName + " == " + expectedValue;
    }

    private String getLocateBy(String locator) {
        return locator;
    }
}

