/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.formats.selenium;

import com.intuit.karate.FileUtils;
import com.intuit.karate.formats.selenium.TestBase;
import com.intuit.karate.formats.selenium.TestCase;
import com.intuit.karate.formats.selenium.TestSuite;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SideProject
extends TestBase {
    String url;
    String version;
    List<String> urls;
    List<TestSuite> suites = new ArrayList<TestSuite>();
    final HashMap<String, String> variables;

    public SideProject(DocumentContext doc) {
        super((String)doc.read("id", new Predicate[0]), (String)doc.read("name", new Predicate[0]));
        this.url = (String)doc.read("$.url", new Predicate[0]);
        this.version = (String)doc.read("$.version", new Predicate[0]);
        this.urls = (List)doc.read("$.urls", new Predicate[0]);
        this.variables = new HashMap();
        List suiteList = (List)doc.read("$.suites", new Predicate[0]);
        for (Map suite : suiteList) {
            this.suites.add(new TestSuite(suite, doc));
        }
        List testsWithoutAnySuite = (List)doc.read("$.tests", new Predicate[0]);
        if (testsWithoutAnySuite != null) {
            ArrayList<TestCase> testsInDefaultSuite = new ArrayList<TestCase>();
            for (Map test : testsWithoutAnySuite) {
                testsInDefaultSuite.add(new TestCase(test));
            }
            if (!testsInDefaultSuite.isEmpty()) {
                this.suites.add(new TestSuite(testsInDefaultSuite));
            }
        }
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public List<String> getUrls() {
        return this.urls;
    }

    public List<TestSuite> getSuites() {
        return this.suites;
    }

    public String convert(File dir, String configJson) {
        StringBuilder sb = new StringBuilder("Feature: Selenium IDE Project - ").append(this.name).append("\n\tid = ").append(this.id).append("\n\tconfig = ").append(configJson).append("\n\n");
        this.appendScenario(sb, configJson, true);
        sb.append("* def driverParams = {session: #(").append("session").append(")}\n");
        int index = 0;
        for (TestSuite suite : this.suites) {
            String featureName = suite.getIdentifierName() + ".feature";
            String testUrl = index < this.urls.size() ? this.urls.get(index++) : this.url;
            FileUtils.writeToFile(new File(dir, featureName), suite.convert(testUrl, this.variables));
            sb.append("\n# calling testsuite ").append(suite.name).append("\n* json featureResponse = call read('./").append(featureName).append("') ").append("driverParams\n");
        }
        sb.append("\n");
        this.appendScenario(sb, configJson, false);
        sb.append("Given url ").append("session.url").append("\nWhen method DELETE\nThen status 200\n");
        return sb.toString();
    }

    private StringBuilder appendScenario(StringBuilder sb, String configJson, boolean isHeader) {
        String name = "Header";
        String method = "POST";
        String sessionId = "response.sessionId";
        if (!isHeader) {
            name = "Footer";
            method = "GET";
            sessionId = "response.value[0].id";
        }
        return sb.append("Scenario: ").append(name).append(" for Project\n").append("* copy ").append("webDriver").append(" = ").append(configJson).append('\n').append("Given url ").append("webDriver.url").append(" + '/session'").append(isHeader ? "\n" : " + 's'\n").append("And request { desiredCapabilities: { caps: {browserName: '#(").append("webDriver.browser").append(")'} } }\n").append("When method ").append(method).append("\nThen status 200\n").append("And assert response.status == 0\n").append("* json ").append("session").append(" = {}\n").append("* set ").append("session.id").append(" = ").append(sessionId).append("\n* set ").append("session.url").append(" = ").append("webDriver.url").append(" + '/session/' + ").append("session.id").append("\n");
    }
}

