/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.safari;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.shell.CommandThread;
import java.util.Map;

public class SafariWebDriver
extends WebDriver {
    public SafariWebDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        super(options, command, http, sessionId, windowId);
    }

    public static SafariWebDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 5555, "safaridriver");
        options.arg("--port=" + options.port);
        CommandThread command = options.startProcess();
        String urlBase = "http://" + options.host + ":" + options.port;
        Http http = Http.forUrl(options.driverLogger, urlBase);
        String sessionId = http.path("session").post("{ capabilities: { browserName: 'Safari' } }").jsonPath("get[0] response..sessionId").asString();
        options.driverLogger.debug("init session id: {}", sessionId);
        http.url(urlBase + "/session/" + sessionId);
        String windowId = http.path("window").get().jsonPath("$.value").asString();
        options.driverLogger.debug("init window id: {}", windowId);
        SafariWebDriver driver = new SafariWebDriver(options, command, http, sessionId, windowId);
        driver.activate();
        return driver;
    }

    @Override
    public void setDimensions(Map<String, Object> map) {
        Integer x = (Integer)map.remove("left");
        Integer y = (Integer)map.remove("top");
        if (x != null) {
            map.put("x", x < 2 ? 2 : x);
        }
        if (y != null) {
            map.put("y", y < 2 ? 2 : y);
        }
        String json = JsonUtils.toJson(map);
        this.http.path("window", "rect").post(json);
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getPlatform()) {
                    case MAC: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Safari\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }
}

