/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver.chrome;

import com.intuit.karate.FileUtils;
import com.intuit.karate.Http;
import com.intuit.karate.Json;
import com.intuit.karate.Logger;
import com.intuit.karate.core.ScenarioContext;
import com.intuit.karate.driver.DriverOptions;
import com.intuit.karate.driver.WebDriver;
import com.intuit.karate.shell.CommandThread;
import java.util.Map;

public class ChromeWebDriver
extends WebDriver {
    public ChromeWebDriver(DriverOptions options, CommandThread command, Http http, String sessionId, String windowId) {
        super(options, command, http, sessionId, windowId);
    }

    public static ChromeWebDriver start(ScenarioContext context, Map<String, Object> map, Logger logger) {
        DriverOptions options = new DriverOptions(context, map, logger, 9515, "chromedriver");
        options.arg("--port=" + options.port);
        options.arg("--user-data-dir=" + options.workingDirPath);
        CommandThread command = options.startProcess();
        String urlBase = "http://" + options.host + ":" + options.port;
        Http http = Http.forUrl(options.driverLogger, urlBase);
        String sessionId = http.path("session").post("{ desiredCapabilities: { browserName: 'Chrome' } }").jsonPath("get[0] response..sessionId").asString();
        options.driverLogger.debug("init session id: {}", sessionId);
        http.url(urlBase + "/session/" + sessionId);
        String windowId = http.path("window").get().jsonPath("$.value").asString();
        options.driverLogger.debug("init window id: {}", windowId);
        ChromeWebDriver driver = new ChromeWebDriver(options, command, http, sessionId, windowId);
        driver.activate();
        return driver;
    }

    @Override
    protected String getJsonPathForElementId() {
        return "$.value.ELEMENT";
    }

    @Override
    protected String getJsonForInput(String text) {
        return "{ value: ['" + text + "'] }";
    }

    @Override
    protected String getJsonForHandle(String text) {
        return new Json().set("name", text).toString();
    }

    @Override
    public String html(String locator) {
        return this.attribute(locator, "innerHTML");
    }

    @Override
    public String value(String locator) {
        return this.attribute(locator, "value");
    }

    @Override
    public String name(String locator) {
        return this.attribute(locator, "tagName");
    }

    @Override
    public void activate() {
        if (!this.options.headless) {
            try {
                switch (FileUtils.getPlatform()) {
                    case MAC: {
                        Runtime.getRuntime().exec(new String[]{"osascript", "-e", "tell app \"Chrome\" to activate"});
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.warn("native window switch failed: {}", e.getMessage());
            }
        }
    }
}

