/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.driver;

import com.intuit.karate.Logger;
import com.intuit.karate.driver.DevToolsMessage;
import com.intuit.karate.driver.DriverOptions;
import java.util.function.Predicate;

public class WaitState {
    private final DriverOptions options;
    private final Logger logger;
    private DevToolsMessage lastSent;
    private Predicate<DevToolsMessage> condition;
    private DevToolsMessage lastReceived;
    private final Predicate<DevToolsMessage> DEFAULT = m -> this.lastSent.getId().equals(m.getId()) && m.getResult() != null;
    public static final Predicate<DevToolsMessage> CHROME_FRAME_RESIZED = WaitState.forEvent("Page.frameResized");
    public static final Predicate<DevToolsMessage> CHROME_INSPECTOR_DETACHED = WaitState.forEvent("Inspector.detached");
    public static final Predicate<DevToolsMessage> CHROME_DIALOG_OPENING = WaitState.forEvent("Page.javascriptDialogOpening");
    public static final Predicate<DevToolsMessage> CHROME_DOM_CONTENT = WaitState.forEvent("Page.domContentEventFired");
    public static final Predicate<DevToolsMessage> NO_WAIT = m -> true;

    public static Predicate<DevToolsMessage> forEvent(String name) {
        return m -> name.equals(m.getMethod());
    }

    public WaitState(DriverOptions options) {
        this.options = options;
        this.logger = options.driverLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DevToolsMessage waitAfterSend(DevToolsMessage dtm, Predicate<DevToolsMessage> condition) {
        this.lastReceived = null;
        this.lastSent = dtm;
        this.condition = condition == null ? this.DEFAULT : condition;
        WaitState waitState = this;
        synchronized (waitState) {
            this.logger.trace(">> wait: {}", dtm);
            try {
                this.wait(this.options.timeout);
            }
            catch (InterruptedException e) {
                this.logger.error("interrupted: {} wait: {}", e.getMessage(), dtm);
            }
        }
        if (this.lastReceived != null) {
            this.logger.trace("<< notified: {}", dtm);
        } else {
            this.logger.warn("<< timed out: {}", dtm);
        }
        return this.lastReceived;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DevToolsMessage dtm) {
        WaitState waitState = this;
        synchronized (waitState) {
            if (this.condition.test(dtm)) {
                this.logger.trace("<< notify: {}", dtm);
                this.lastReceived = dtm;
                this.notify();
            } else {
                this.logger.trace("<< ignore: {}", dtm);
            }
        }
    }
}

