/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.core.Embed;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.core.Result;
import com.intuit.karate.core.Step;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StepResult {
    private static final Map<String, Object> DUMMY_MATCH = new HashMap<String, Object>(2);
    private final Step step;
    private final Result result;
    private final Embed embed;
    private final List<FeatureResult> callResults;
    private final boolean hidden;
    private String stepLog;

    public void appendToStepLog(String log) {
        if (log == null || this.stepLog == null) {
            return;
        }
        this.stepLog = this.stepLog + log;
    }

    private static Map<String, Object> docStringToMap(int line, String text) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("content_type", "");
        map.put("line", line);
        map.put("value", text);
        return map;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("line", this.step.getLine());
        map.put("keyword", this.step.getPrefix());
        map.put("name", this.step.getText());
        map.put("result", this.result.toMap());
        map.put("match", DUMMY_MATCH);
        StringBuilder sb = new StringBuilder();
        if (this.step.getDocString() != null) {
            sb.append(this.step.getDocString());
        }
        if (this.stepLog != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(this.stepLog);
        }
        if (sb.length() > 0) {
            map.put("doc_string", StepResult.docStringToMap(this.step.getLine(), sb.toString()));
        }
        if (this.embed != null) {
            HashMap<String, String> embedMap = new HashMap<String, String>(2);
            embedMap.put("data", this.embed.getBase64());
            embedMap.put("mime_type", this.embed.getMimeType());
            map.put("embeddings", Collections.singletonList(embedMap));
        }
        return map;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isStopped() {
        return this.result.isFailed() || this.result.isAborted();
    }

    public StepResult(boolean hidden, Step step, Result result, String stepLog, Embed embed, List<FeatureResult> callResults) {
        this.hidden = hidden;
        this.step = step;
        this.result = result;
        this.stepLog = stepLog;
        this.embed = embed;
        this.callResults = callResults;
    }

    public Step getStep() {
        return this.step;
    }

    public Result getResult() {
        return this.result;
    }

    public String getStepLog() {
        return this.stepLog;
    }

    public Embed getEmbed() {
        return this.embed;
    }

    public List<FeatureResult> getCallResults() {
        return this.callResults;
    }

    static {
        DUMMY_MATCH.put("location", "karate");
        DUMMY_MATCH.put("arguments", Collections.EMPTY_LIST);
    }
}

