/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.FileUtils;
import com.intuit.karate.JsonUtils;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Engine;
import com.intuit.karate.core.Feature;
import com.intuit.karate.core.Scenario;
import com.intuit.karate.core.ScenarioResult;
import com.intuit.karate.core.StepResult;
import com.intuit.karate.core.Tags;
import com.intuit.karate.exception.KarateException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class FeatureResult {
    private final Feature feature;
    private final String displayName;
    private final List<ScenarioResult> scenarioResults = new ArrayList<ScenarioResult>();
    private int scenarioCount;
    private int failedCount;
    private List<Throwable> errors;
    private double durationMillis;
    private ScriptValueMap resultVars;
    private Map<String, Object> callArg;
    private int loopIndex;

    public void printStats(String reportPath) {
        StringBuilder sb = new StringBuilder();
        sb.append("---------------------------------------------------------\n");
        sb.append("feature: ").append(this.feature.getRelativePath()).append('\n');
        if (reportPath != null) {
            sb.append("report: ").append(reportPath).append('\n');
        }
        sb.append(String.format("scenarios: %2d | passed: %2d | failed: %2d | time: %.4f\n", this.scenarioCount, this.scenarioCount - this.failedCount, this.failedCount, this.durationMillis / 1000.0));
        sb.append("---------------------------------------------------------");
        System.out.println(sb);
    }

    public Map<String, Object> toMap() {
        String temp;
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.scenarioResults.size());
        map.put("elements", list);
        for (ScenarioResult re : this.scenarioResults) {
            if (re.getScenario().getFeature().isBackgroundPresent()) {
                list.add(re.backgroundToMap());
            }
            list.add(re.toMap());
        }
        map.put("keyword", "Feature");
        map.put("line", this.feature.getLine());
        map.put("uri", this.displayName);
        map.put("name", this.displayName);
        map.put("id", StringUtils.toIdString(this.feature.getName()));
        String string = temp = this.feature.getName() == null ? "" : this.feature.getName();
        if (this.feature.getDescription() != null) {
            temp = temp + "\n" + this.feature.getDescription();
        }
        map.put("description", temp.trim());
        if (this.feature.getTags() != null) {
            map.put("tags", Tags.toResultList(this.feature.getTags()));
        }
        return map;
    }

    public List<StepResult> getStepResults() {
        ArrayList<StepResult> list = new ArrayList<StepResult>();
        for (ScenarioResult sr : this.scenarioResults) {
            list.addAll(sr.getStepResults());
        }
        return list;
    }

    public FeatureResult(Feature feature) {
        this.feature = feature;
        this.displayName = FileUtils.removePrefix(feature.getRelativePath());
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getPackageQualifiedName() {
        return this.feature.getResource().getPackageQualifiedName();
    }

    public String getDisplayUri() {
        return this.displayName;
    }

    public KarateException getErrorsCombined() {
        if (this.errors == null) {
            return null;
        }
        if (this.errors.size() == 1) {
            Throwable error = this.errors.get(0);
            if (error instanceof KarateException) {
                return (KarateException)error;
            }
            return new KarateException("call failed", error);
        }
        return new KarateException(this.getErrorMessages());
    }

    public String getErrorMessages() {
        StringBuilder sb = new StringBuilder();
        Iterator<Throwable> iterator = this.errors.iterator();
        while (iterator.hasNext()) {
            Throwable error = iterator.next();
            sb.append(error.getMessage());
            if (!iterator.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public String getCallName() {
        String append = this.loopIndex == -1 ? "" : "[" + this.loopIndex + "] ";
        return append + this.displayName;
    }

    public String getCallArgPretty() {
        if (this.callArg == null) {
            return null;
        }
        Map temp = JsonUtils.removeCyclicReferences(this.callArg);
        return JsonUtils.toPrettyJsonString(JsonUtils.toJsonDoc(temp));
    }

    public Map<String, Object> getCallArg() {
        return this.callArg;
    }

    public void setCallArg(Map<String, Object> callArg) {
        this.callArg = callArg;
    }

    public int getLoopIndex() {
        return this.loopIndex;
    }

    public void setLoopIndex(int loopIndex) {
        this.loopIndex = loopIndex;
    }

    public double getDurationMillis() {
        return this.durationMillis;
    }

    public int getFailedCount() {
        return this.failedCount;
    }

    public int getScenarioCount() {
        return this.scenarioCount;
    }

    public boolean isFailed() {
        return this.errors != null && !this.errors.isEmpty();
    }

    public List<Throwable> getErrors() {
        return this.errors;
    }

    public Map<String, Object> getResultAsPrimitiveMap() {
        if (this.resultVars == null) {
            return Collections.EMPTY_MAP;
        }
        return this.resultVars.toPrimitiveMap();
    }

    public void setResultVars(ScriptValueMap resultVars) {
        this.resultVars = resultVars;
    }

    private void addError(Throwable error) {
        ++this.failedCount;
        if (this.errors == null) {
            this.errors = new ArrayList<Throwable>();
        }
        this.errors.add(error);
    }

    public void addResult(ScenarioResult result) {
        this.scenarioResults.add(result);
        this.durationMillis += Engine.nanosToMillis(result.getDurationNanos());
        ++this.scenarioCount;
        if (result.isFailed()) {
            Scenario scenario = result.getScenario();
            if (scenario.isOutline()) {
                Throwable error = result.getError();
                KarateException copy = new KarateException(scenario.getDisplayMeta() + " " + error.getMessage());
                copy.setStackTrace(error.getStackTrace());
                this.addError(copy);
            } else {
                this.addError(result.getError());
            }
        }
    }

    public List<ScenarioResult> getScenarioResults() {
        return this.scenarioResults;
    }
}

