/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.CallResult;
import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;

public class FeatureContext {
    public final String env;
    public final String tagSelector;
    public final Feature feature;
    public final Path parentPath;
    public final Map<String, CallResult> callCache;
    public final String packageQualifiedName;

    private static String getEnv(String envString) {
        String temp = StringUtils.trimToNull(envString);
        if (temp == null) {
            temp = StringUtils.trimToNull(System.getProperty("karate.env"));
        }
        return temp;
    }

    public FeatureContext(String envString, Feature feature, File workingDir, String tagSelector) {
        this.env = FeatureContext.getEnv(envString);
        this.tagSelector = tagSelector;
        this.feature = feature;
        this.callCache = new HashMap<String, CallResult>(1);
        this.parentPath = workingDir == null ? feature.getPath().getParent() : workingDir.toPath();
        this.packageQualifiedName = workingDir == null ? feature.getResource().getPackageQualifiedName() : "";
    }

    public static FeatureContext forEnv(String env) {
        return FeatureContext.forWorkingDir(env, null);
    }

    public static FeatureContext forEnv() {
        return FeatureContext.forWorkingDir(null, null);
    }

    public static FeatureContext forWorkingDir(File file) {
        return FeatureContext.forWorkingDir(null, file);
    }

    public static FeatureContext forWorkingDir(String env, File file) {
        if (file == null) {
            file = new File("");
        }
        return new FeatureContext(env, null, file);
    }

    public static FeatureContext forFeatureAndWorkingDir(String env, Feature feature, File file) {
        return new FeatureContext(env, feature, file);
    }

    public FeatureContext(String env, Feature feature, String tagSelector) {
        this(env, feature, null, tagSelector);
    }

    private FeatureContext(String env, Feature feature, File workingDir) {
        this(env, feature, workingDir, null);
    }

    public String toString() {
        return this.feature.getRelativePath() + ", env: " + this.env;
    }
}

