/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.core;

import com.intuit.karate.CallContext;
import com.intuit.karate.FileUtils;
import com.intuit.karate.LogAppender;
import com.intuit.karate.Logger;
import com.intuit.karate.core.FeatureContext;
import com.intuit.karate.core.FeatureResult;
import com.intuit.karate.shell.FileLogAppender;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;

public class ExecutionContext {
    public final long startTime;
    public final FeatureContext featureContext;
    public final CallContext callContext;
    public final FeatureResult result;
    public final Consumer<Runnable> system;
    public final ExecutorService scenarioExecutor;
    private final File reportDir;

    public ExecutionContext(long startTime, FeatureContext featureContext, CallContext callContext, String reportDirString, Consumer<Runnable> system, ExecutorService scenarioExecutor) {
        this.scenarioExecutor = scenarioExecutor;
        this.startTime = startTime;
        this.result = new FeatureResult(featureContext.feature);
        this.featureContext = featureContext;
        this.callContext = callContext;
        if (callContext.perfMode) {
            this.reportDir = null;
        } else {
            if (reportDirString == null) {
                reportDirString = FileUtils.getBuildDir() + File.separator + "surefire-reports";
            }
            this.reportDir = new File(reportDirString);
            if (!this.reportDir.exists()) {
                this.reportDir.mkdirs();
            }
        }
        this.system = system == null ? r -> r.run() : system;
    }

    public LogAppender getLogAppender(String suffix, Logger logger) {
        if (this.reportDir == null) {
            return LogAppender.NO_OP;
        }
        String basePath = this.featureContext.packageQualifiedName;
        return new FileLogAppender(this.reportDir + File.separator + basePath + suffix + ".log", logger);
    }
}

