/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ScriptObjectMap
implements Map<String, Object> {
    private final ScriptValueMap map;

    public ScriptObjectMap(ScriptValueMap map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public Collection<Object> values() {
        return this.map.values().stream().map(ScriptValue::getAfterConvertingFromJsonOrXmlIfNeeded).collect(Collectors.toList());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Object get(Object key) {
        ScriptValue sv = (ScriptValue)this.map.get(key);
        return sv == null ? null : sv.getAfterConvertingFromJsonOrXmlIfNeeded();
    }

    @Override
    public Object put(String key, Object value) {
        return this.map.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        m.forEach((k, v) -> this.put((String)k, v));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap temp = new HashMap(this.size());
        this.map.forEach((k, sv) -> {
            Object value = sv == null ? null : sv.getAfterConvertingFromJsonOrXmlIfNeeded();
            temp.put(k, value);
        });
        return temp.entrySet();
    }
}

