/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate;

import com.intuit.karate.StringUtils;
import com.intuit.karate.core.Feature;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.json.JsonSmartJsonProvider;
import com.jayway.jsonpath.spi.mapper.JsonSmartMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvReader;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import net.minidev.json.JSONStyle;
import net.minidev.json.JSONValue;
import net.minidev.json.reader.JsonWriter;
import net.minidev.json.reader.JsonWriterI;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class JsonUtils {
    private JsonUtils() {
    }

    public static DocumentContext toJsonDoc(String raw) {
        return JsonPath.parse((String)raw);
    }

    public static String toStrictJsonString(String raw) {
        DocumentContext dc = JsonUtils.toJsonDoc(raw);
        return dc.jsonString();
    }

    public static String toJson(Object o) {
        return JSONValue.toJSONString((Object)o);
    }

    public static Map removeCyclicReferences(Map map) {
        Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());
        seen.add(map);
        map = new LinkedHashMap(map);
        JsonUtils.recurseCyclic(0, map, seen);
        return map;
    }

    private static boolean recurseCyclic(int depth, Object o, Set<Object> seen) {
        if (o instanceof Map) {
            if (depth > 10 || !seen.add(o)) {
                return true;
            }
            Map map = (Map)o;
            map.forEach((k, v) -> {
                if (JsonUtils.recurseCyclic(depth + 1, v, seen)) {
                    map.put(k, "#" + v.getClass().getName());
                }
            });
        } else if (o instanceof List) {
            if (depth > 10 || !seen.add(o)) {
                return true;
            }
            List list = (List)o;
            int count = list.size();
            for (int i = 0; i < count; ++i) {
                Object v2 = list.get(i);
                if (!JsonUtils.recurseCyclic(depth + 1, v2, seen)) continue;
                list.set(i, "#" + v2.getClass().getName());
            }
        }
        return false;
    }

    public static DocumentContext toJsonDoc(Object o) {
        return JsonUtils.toJsonDoc(JsonUtils.toJson(o));
    }

    public static Object fromJson(String s, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return JSONValue.parse((String)s, clazz);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T fromJson(String s, Class<T> clazz) {
        return (T)JsonUtils.fromJson(s, clazz.getName());
    }

    public static String toPrettyJsonString(DocumentContext doc) {
        Object o = doc.read("$", new Predicate[0]);
        StringBuilder sb = new StringBuilder();
        Set<Object> seen = Collections.newSetFromMap(new IdentityHashMap());
        JsonUtils.recursePretty(o, sb, 0, seen);
        sb.append('\n');
        return sb.toString();
    }

    private static void pad(StringBuilder sb, int depth) {
        for (int i = 0; i < depth; ++i) {
            sb.append(' ').append(' ');
        }
    }

    private static void ref(StringBuilder sb, Object o) {
        sb.append("\"#ref:").append(o.getClass().getName()).append('\"');
    }

    public static String escapeValue(String raw) {
        return JSONValue.escape((String)raw, (JSONStyle)JSONStyle.LT_COMPRESS);
    }

    public static void removeKeysWithNullValues(Object o) {
        block4: {
            block3: {
                if (!(o instanceof Map)) break block3;
                Map map = (Map)o;
                for (Map.Entry entry : map.entrySet()) {
                    Object v = entry.getValue();
                    if (v == null) {
                        map.remove(entry.getKey());
                        continue;
                    }
                    JsonUtils.removeKeysWithNullValues(v);
                }
                break block4;
            }
            if (!(o instanceof List)) break block4;
            List list = (List)o;
            for (Object v : list) {
                JsonUtils.removeKeysWithNullValues(v);
            }
        }
    }

    private static void recursePretty(Object o, StringBuilder sb, int depth, Set<Object> seen) {
        if (o == null) {
            sb.append("null");
        } else if (o instanceof Map) {
            if (seen.add(o)) {
                sb.append('{').append('\n');
                Map map = (Map)o;
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String key = (String)entry.getKey();
                    JsonUtils.pad(sb, depth + 1);
                    sb.append('\"').append(JsonUtils.escapeValue(key)).append('\"');
                    sb.append(':').append(' ');
                    JsonUtils.recursePretty(entry.getValue(), sb, depth + 1, seen);
                    if (iterator.hasNext()) {
                        sb.append(',');
                    }
                    sb.append('\n');
                }
                JsonUtils.pad(sb, depth);
                sb.append('}');
            } else {
                JsonUtils.ref(sb, o);
            }
        } else if (o instanceof List) {
            List list = (List)o;
            Iterator iterator = list.iterator();
            if (seen.add(o)) {
                sb.append('[').append('\n');
                while (iterator.hasNext()) {
                    Object child = iterator.next();
                    JsonUtils.pad(sb, depth + 1);
                    JsonUtils.recursePretty(child, sb, depth + 1, seen);
                    if (iterator.hasNext()) {
                        sb.append(',');
                    }
                    sb.append('\n');
                }
                JsonUtils.pad(sb, depth);
                sb.append(']');
            } else {
                JsonUtils.ref(sb, o);
            }
        } else if (o instanceof String) {
            String value = (String)o;
            sb.append('\"').append(JsonUtils.escapeValue(value)).append('\"');
        } else {
            sb.append(o);
        }
    }

    public static StringUtils.Pair getParentAndLeafPath(String path) {
        String right;
        int pos = path.lastIndexOf(46);
        int temp = path.lastIndexOf("['");
        if (temp != -1 && temp > pos) {
            pos = temp - 1;
        }
        if ((right = path.substring(pos + 1)).startsWith("[")) {
            ++pos;
        }
        String left = path.substring(0, pos == -1 ? 0 : pos);
        return StringUtils.pair(left, right);
    }

    public static void removeValueByPath(DocumentContext doc, String path) {
        JsonUtils.setValueByPath(doc, path, null, true);
    }

    public static void setValueByPath(DocumentContext doc, String path, Object value) {
        JsonUtils.setValueByPath(doc, path, value, false);
    }

    public static void setValueByPath(DocumentContext doc, String path, Object value, boolean remove) {
        block18: {
            if ("$".equals(path)) {
                throw new RuntimeException("cannot replace root path $");
            }
            StringUtils.Pair pathLeaf = JsonUtils.getParentAndLeafPath(path);
            String left = pathLeaf.left;
            String right = pathLeaf.right;
            if (right.endsWith("]") && !right.endsWith("']")) {
                int indexPos = right.lastIndexOf(91);
                int index = -1;
                if (right.length() != indexPos + 1) {
                    try {
                        index = Integer.valueOf(right.substring(indexPos + 1, right.length() - 1));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                String listPath = (right = right.substring(0, indexPos)).startsWith("[") ? left + right : ("".equals(left) ? right : left + "." + right);
                try {
                    List list = (List)doc.read(listPath, new Predicate[0]);
                    if (index == -1) {
                        index = list.size();
                    }
                    if (index < list.size()) {
                        if (remove) {
                            list.remove(index);
                        } else {
                            list.set(index, value);
                        }
                    } else if (!remove) {
                        list.add(value);
                    }
                    break block18;
                }
                catch (Exception e) {
                    if (!remove) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        list.add(value);
                        doc.put(left, right, list, new Predicate[0]);
                    }
                    break block18;
                }
            }
            if (remove) {
                doc.delete(path, new Predicate[0]);
            } else {
                if (right.startsWith("[")) {
                    right = right.substring(2, right.length() - 2);
                }
                if (!JsonUtils.pathExists(doc, left)) {
                    JsonUtils.createParents(doc, left);
                }
                doc.put(left, right, value, new Predicate[0]);
            }
        }
    }

    private static void createParents(DocumentContext doc, String path) {
        Cloneable empty;
        StringUtils.Pair pathLeaf = JsonUtils.getParentAndLeafPath(path);
        String left = pathLeaf.left;
        String right = pathLeaf.right;
        if ("".equals(left)) {
            if (!"$".equals(right)) {
                doc.add("$", new LinkedHashMap(), new Predicate[0]);
            }
            return;
        }
        if (!JsonUtils.pathExists(doc, left)) {
            JsonUtils.createParents(doc, left);
        }
        if (right.endsWith("]") && !right.endsWith("']")) {
            int pos = right.indexOf(91);
            right = right.substring(0, pos);
            ArrayList list = new ArrayList();
            list.add(new LinkedHashMap());
            empty = list;
        } else {
            empty = new LinkedHashMap();
        }
        doc.put(left, right, empty, new Predicate[0]);
    }

    public static boolean pathExists(DocumentContext doc, String path) {
        try {
            return doc.read(path, new Predicate[0]) != null;
        }
        catch (PathNotFoundException pnfe) {
            return false;
        }
    }

    public static DocumentContext fromYaml(String raw) {
        Yaml yaml = new Yaml((BaseConstructor)new SafeConstructor());
        Object o = yaml.load(raw);
        return JsonPath.parse((Object)o);
    }

    public static DocumentContext fromCsv(String raw) {
        CsvReader reader = new CsvReader();
        reader.setContainsHeader(true);
        try {
            CsvContainer csv = reader.read((Reader)new StringReader(raw));
            ArrayList<Map> rows = new ArrayList<Map>(csv.getRowCount());
            for (CsvRow row : csv.getRows()) {
                rows.add(row.getFieldMap());
            }
            return JsonUtils.toJsonDoc(rows);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String buildPath(String parentPath, String key) {
        boolean needsQuotes = key.indexOf(45) != -1 || key.indexOf(32) != -1 || key.indexOf(46) != -1;
        return needsQuotes ? parentPath + "['" + key + "']" : parentPath + '.' + key;
    }

    public static DocumentContext emptyJsonObject() {
        return JsonUtils.toJsonDoc(new LinkedHashMap());
    }

    public static DocumentContext emptyJsonArray(int length) {
        ArrayList list = new ArrayList(length);
        for (int i = 0; i < length; ++i) {
            list.add(new LinkedHashMap());
        }
        return JsonUtils.toJsonDoc(list);
    }

    static {
        JSONValue.registerWriter(ScriptObjectMirror.class, (JsonWriterI)new NashornObjectJsonWriter());
        JSONValue.registerWriter(Feature.class, (JsonWriterI)new FeatureJsonWriter());
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JsonSmartJsonProvider();
            private final MappingProvider mappingProvider = new JsonSmartMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set<Option> options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    private static class FeatureJsonWriter
    implements JsonWriterI<Feature> {
        private FeatureJsonWriter() {
        }

        public <E extends Feature> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            JsonWriter.toStringWriter.writeJSONString((Object)"\"#feature\"", out, compression);
        }
    }

    private static class NashornObjectJsonWriter
    implements JsonWriterI<ScriptObjectMirror> {
        private NashornObjectJsonWriter() {
        }

        public <E extends ScriptObjectMirror> void writeJSONString(E value, Appendable out, JSONStyle compression) throws IOException {
            if (value.isArray()) {
                Object[] array = value.values().toArray();
                JsonWriter.arrayWriter.writeJSONString((Object)array, out, compression);
            } else if (value.isFunction()) {
                JsonWriter.toStringWriter.writeJSONString((Object)"\"#function\"", out, compression);
            } else {
                JsonWriter.JSONMapWriter.writeJSONString(value, out, compression);
            }
        }
    }
}

