/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.StringTooltipCell;
import com.intuit.karate.ui.Var;
import com.intuit.karate.ui.VarValueCell;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;

public class VarsPanel
extends BorderPane {
    private final AppSession session;
    private final TableView<Var> table;

    public VarsPanel(AppSession session) {
        this.session = session;
        this.table = new TableView();
        this.table.setPrefWidth(300.0);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setCenter((Node)this.table);
        TableColumn nameCol = new TableColumn("Variable");
        nameCol.setMinWidth(120.0);
        nameCol.setMaxWidth(250.0);
        nameCol.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameCol.setCellFactory(c -> new StringTooltipCell());
        TableColumn typeCol = new TableColumn("Type");
        typeCol.setMinWidth(45.0);
        typeCol.setMaxWidth(60.0);
        typeCol.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        TableColumn valueCol = new TableColumn("Value");
        valueCol.setCellValueFactory(c -> new ReadOnlyObjectWrapper((Object)((Var)c.getValue()).getValue()));
        valueCol.setCellFactory(c -> new VarValueCell());
        this.table.getColumns().addAll((Object[])new TableColumn[]{nameCol, typeCol, valueCol});
        this.table.setItems(session.getVars());
        this.table.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(e -> {
                if (e.getClickCount() == 2 && !row.isEmpty()) {
                    Var var = (Var)row.getItem();
                    session.logVar(var);
                }
            });
            return row;
        });
    }

    public void refresh() {
        this.table.setItems(this.session.getVars());
        this.table.refresh();
    }
}

