/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import javafx.scene.control.TextArea;
import org.slf4j.LoggerFactory;

public class TextAreaLogAppender
extends AppenderBase<ILoggingEvent> {
    private final TextArea textArea;
    private final Logger logger;
    private final PatternLayoutEncoder encoder;

    public TextAreaLogAppender(TextArea textArea) {
        this.textArea = textArea;
        this.logger = (Logger)LoggerFactory.getLogger((String)"com.intuit.karate");
        this.setName("karate-ui");
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.setContext((Context)lc);
        this.encoder = new PatternLayoutEncoder();
        this.encoder.setPattern("%d{HH:mm:ss.SSS} %-5level - %msg%n");
        this.encoder.setContext(this.context);
        this.encoder.start();
        this.start();
        this.logger.addAppender((Appender)this);
        this.logger.setLevel(Level.DEBUG);
    }

    protected void append(ILoggingEvent event) {
        byte[] bytes = this.encoder.encode((Object)event);
        try {
            String line = new String(bytes, "utf-8");
            this.textArea.appendText(line);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

