/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.AppSession;
import com.intuit.karate.ui.ExamplesPanel;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class ScenarioOutlinePanel
extends BorderPane {
    private final VBox content;
    private final AppSession session;
    private ScenarioOutlineWrapper outline;
    private final List<ExamplesPanel> examplesPanels;

    public ScenarioOutlinePanel(AppSession session, ScenarioOutlineWrapper outline) {
        this.session = session;
        this.outline = outline;
        this.content = new VBox(0.0);
        this.setCenter((Node)this.content);
        this.examplesPanels = new ArrayList<ExamplesPanel>(outline.getScenarios().size());
        this.initTitleAndContent();
    }

    private void initTitleAndContent() {
        for (ScenarioWrapper scenario : this.outline.getScenarios()) {
            ExamplesPanel examplePanel = new ExamplesPanel(this.session, scenario);
            this.content.getChildren().add((Object)examplePanel);
            if (!this.examplesPanels.isEmpty()) {
                examplePanel.setExpanded(false);
            }
            this.examplesPanels.add(examplePanel);
        }
    }

    public void action(AppAction action) {
        this.outline = this.session.refresh(this.outline);
        for (ExamplesPanel panel : this.examplesPanels) {
            panel.refresh(action);
        }
    }
}

