/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.ui;

import com.intuit.karate.FileUtils;
import com.intuit.karate.ScriptEnv;
import com.intuit.karate.ScriptValue;
import com.intuit.karate.ScriptValueMap;
import com.intuit.karate.cucumber.CucumberUtils;
import com.intuit.karate.cucumber.FeatureFilePath;
import com.intuit.karate.cucumber.FeatureSection;
import com.intuit.karate.cucumber.FeatureWrapper;
import com.intuit.karate.cucumber.KarateBackend;
import com.intuit.karate.cucumber.ScenarioOutlineWrapper;
import com.intuit.karate.cucumber.ScenarioWrapper;
import com.intuit.karate.cucumber.StepWrapper;
import com.intuit.karate.ui.AppAction;
import com.intuit.karate.ui.FeaturePanel;
import com.intuit.karate.ui.HeaderPanel;
import com.intuit.karate.ui.LogPanel;
import com.intuit.karate.ui.StepException;
import com.intuit.karate.ui.Var;
import com.intuit.karate.ui.VarsPanel;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppSession {
    private static final Logger logger = LoggerFactory.getLogger(AppSession.class);
    public final File featureFile;
    private FeatureWrapper feature;
    public final KarateBackend backend;
    public final HeaderPanel headerPanel;
    public final FeaturePanel featurePanel;
    public final VarsPanel varsPanel;
    public final LogPanel logPanel;

    public FeatureWrapper getFeature() {
        return this.feature;
    }

    public AppSession(File featureFile, String envString) {
        this(featureFile, envString, false);
    }

    public ScriptEnv getEnv() {
        return this.backend.getEnv();
    }

    public void resetBackendAndVarsTable(String env) {
        this.backend.getObjectFactory().reset(env);
        this.refreshVarsTable();
    }

    public void resetAll(String env) {
        this.resetBackendAndVarsTable(env);
        this.featurePanel.action(AppAction.RESET);
    }

    public void runAll() {
        try {
            this.featurePanel.action(AppAction.RUN);
        }
        catch (StepException se) {
            logger.error("step execution paused.");
        }
    }

    public AppSession(File featureFile, String envString, boolean test) {
        this.featureFile = featureFile;
        FeatureFilePath ffp = FileUtils.parseFeaturePath(featureFile);
        ScriptEnv env = ScriptEnv.init(envString, ffp.file, ffp.searchPaths, logger);
        this.feature = FeatureWrapper.fromFile(ffp.file, env);
        this.backend = CucumberUtils.getBackendWithGlue(env, null, null, false);
        if (!test) {
            this.headerPanel = new HeaderPanel(this);
            this.featurePanel = new FeaturePanel(this);
            this.varsPanel = new VarsPanel(this);
            this.logPanel = new LogPanel();
        } else {
            this.headerPanel = null;
            this.featurePanel = null;
            this.varsPanel = null;
            this.logPanel = null;
        }
    }

    public void logVar(Var var) {
        if (this.logPanel != null) {
            String description = var.getName() + " (" + var.getValue().getTypeAsShortString() + "): ";
            this.logPanel.append(description);
            String value = var.getValue().getAsPrettyString();
            if (value != null && value.indexOf(10) != -1) {
                String dashes = StringUtils.repeat((char)'-', (int)(description.length() - 1));
                this.logPanel.append('\n' + dashes + '\n');
            }
            this.logPanel.append(var.getValue().getAsPrettyString() + '\n');
        }
    }

    public void refreshVarsTable() {
        this.varsPanel.refresh();
    }

    public FeatureSection refresh(FeatureSection section) {
        return this.feature.getSection(section.getIndex());
    }

    public ScenarioOutlineWrapper refresh(ScenarioOutlineWrapper outline) {
        return this.feature.getSection(outline.getSection().getIndex()).getScenarioOutline();
    }

    public ScenarioWrapper refresh(ScenarioWrapper scenario) {
        return this.feature.getScenario(scenario.getSection().getIndex(), scenario.getIndex());
    }

    public StepWrapper refresh(StepWrapper step) {
        int stepIndex = step.getIndex();
        int scenarioIndex = step.getScenario().getIndex();
        int sectionIndex = step.getScenario().getSection().getIndex();
        return this.feature.getStep(sectionIndex, scenarioIndex, stepIndex);
    }

    public void replace(StepWrapper step, String text) {
        this.feature = this.feature.replaceStep(step, text);
        this.featurePanel.action(AppAction.REFRESH);
        this.headerPanel.initTextContent();
    }

    public ObservableList<Var> getVars() {
        if (this.backend.getStepDefs() == null) {
            return FXCollections.emptyObservableList();
        }
        ScriptValueMap map = this.backend.getStepDefs().getContext().getVars();
        ArrayList<Var> list = new ArrayList<Var>(map.size());
        for (Map.Entry entry : map.entrySet()) {
            list.add(new Var((String)entry.getKey(), (ScriptValue)entry.getValue()));
        }
        return FXCollections.observableList(list);
    }
}

