/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Cookie
extends LinkedHashMap<String, String> {
    public static final String NAME = "name";
    public static final String VALUE = "value";
    public static final String DOMAIN = "domain";
    public static final String PATH = "path";
    public static final String VERSION = "version";
    public static final String EXPIRES = "expires";
    public static final String MAX_AGE = "max-age";
    public static final String SECURE = "secure";
    public static final String PERSISTENT = "persistent";
    public static final String HTTP_ONLY = "http-only";

    public static List<Cookie> toCookies(Map<String, Object> map) {
        if (map == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object o = entry.getValue();
            if (o instanceof Map) {
                cookies.add(new Cookie((Map)o));
                continue;
            }
            if (o == null) continue;
            cookies.add(new Cookie(entry.getKey(), o.toString()));
        }
        return cookies;
    }

    public Cookie(Map<String, String> map) {
        super(map);
    }

    public Cookie(String name, String value) {
        this.put(NAME, name);
        this.put(VALUE, value);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String getValue() {
        return (String)this.get(VALUE);
    }
}

