/*
 * Decompiled with CFR 0.152.
 */
package com.intuit.karate.cucumber;

import com.intuit.karate.cucumber.KarateJunitFormatter;
import cucumber.runtime.formatter.CucumberJSONFormatter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import gherkin.formatter.model.Background;
import gherkin.formatter.model.Examples;
import gherkin.formatter.model.Feature;
import gherkin.formatter.model.Match;
import gherkin.formatter.model.Result;
import gherkin.formatter.model.Scenario;
import gherkin.formatter.model.ScenarioOutline;
import gherkin.formatter.model.Step;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

public class KarateReporter
implements Formatter,
Reporter {
    private final KarateJunitFormatter junit;
    private final CucumberJSONFormatter json;

    public KarateJunitFormatter getJunitFormatter() {
        return this.junit;
    }

    public KarateReporter(String featurePath, String reportPath) throws IOException {
        this.junit = new KarateJunitFormatter(featurePath, reportPath);
        String jsonReportPath = reportPath.replaceFirst("\\.xml$", ".json");
        FileWriter fileWriter = new FileWriter(jsonReportPath);
        this.json = new CucumberJSONFormatter((Appendable)fileWriter);
    }

    public void syntaxError(String state, String event, List<String> legalEvents, String uri, Integer line) {
        this.junit.syntaxError(state, event, legalEvents, uri, line);
        this.json.syntaxError(state, event, legalEvents, uri, line);
    }

    public void uri(String uri) {
        this.junit.uri(uri);
        this.json.uri(uri);
    }

    public void feature(Feature feature) {
        this.junit.feature(feature);
        this.json.feature(feature);
    }

    public void scenarioOutline(ScenarioOutline scenarioOutline) {
        this.junit.scenarioOutline(scenarioOutline);
        this.json.scenarioOutline(scenarioOutline);
    }

    public void examples(Examples examples) {
        this.junit.examples(examples);
        this.json.examples(examples);
    }

    public void startOfScenarioLifeCycle(Scenario scenario) {
        this.junit.startOfScenarioLifeCycle(scenario);
        this.json.startOfScenarioLifeCycle(scenario);
    }

    public void background(Background background) {
        this.junit.background(background);
        this.json.background(background);
    }

    public void scenario(Scenario scenario) {
        this.junit.scenario(scenario);
        this.json.scenario(scenario);
    }

    public void step(Step step) {
        this.junit.step(step);
        this.json.step(step);
    }

    public void endOfScenarioLifeCycle(Scenario scenario) {
        this.junit.endOfScenarioLifeCycle(scenario);
        this.json.endOfScenarioLifeCycle(scenario);
    }

    public void done() {
        this.junit.done();
        this.json.done();
    }

    public void close() {
        this.junit.close();
        this.json.close();
    }

    public void eof() {
        this.junit.eof();
        this.json.eof();
    }

    public void before(Match match, Result result) {
        this.junit.before(match, result);
        this.json.before(match, result);
    }

    public void result(Result result) {
        this.junit.result(result);
        this.json.result(result);
    }

    public void after(Match match, Result result) {
        this.junit.after(match, result);
        this.json.after(match, result);
    }

    public void match(Match match) {
        this.junit.match(match);
        this.json.match(match);
    }

    public void embedding(String mimeType, byte[] data) {
        this.junit.embedding(mimeType, data);
        this.json.embedding(mimeType, data);
    }

    public void write(String text) {
        this.junit.write(text);
        this.json.write(text);
    }
}

