/*
 * Decompiled with CFR 0.152.
 */
package com.internetitem.maven.writePropertiesFile;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="write-properties-file", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true)
public class WritePropertiesFileMojo
extends AbstractMojo {
    @Parameter(property="outputDirectory", defaultValue="${project.build.outputDirectory}", required=true)
    private File outputDirectory;
    @Parameter(property="filename", required=true)
    private String filename;
    @Parameter(property="properties", required=true)
    private Properties properties;
    @Parameter(property="comment", defaultValue="Generated by write-property-file Maven plugin")
    private String comment;
    @Parameter(property="createDirectory", defaultValue="true")
    private boolean createDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File finalFile = new File(this.outputDirectory, this.filename).getAbsoluteFile();
        String finalFilename = finalFile.getAbsolutePath();
        File finalDirectory = finalFile.getParentFile();
        String finalDirectoryName = finalDirectory.getAbsolutePath();
        if (!finalDirectory.exists()) {
            this.getLog().info((CharSequence)("Creating directory " + finalDirectoryName));
            finalDirectory.mkdirs();
        }
        this.getLog().info((CharSequence)("Saving properties to file " + finalFilename));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(finalFile);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, Charset.forName("UTF-8"));
            String finalComment = this.comment;
            if (this.comment != null && this.comment.trim().isEmpty()) {
                finalComment = null;
            }
            this.properties.store(writer, finalComment);
            writer.close();
            out.close();
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to save properties to file " + finalFilename + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception e) {}
            }
        }
    }
}

