/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.ListUtils;
import com.instabug.library.util.TimeUtils;
import com.instabug.survey.e.c.a;
import com.instabug.survey.e.c.e;
import com.instabug.survey.e.c.f;
import com.instabug.survey.e.c.g;
import com.instabug.survey.e.c.i;
import com.instabug.survey.models.b;
import com.instabug.survey.models.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
Serializable,
e {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private static final String KEY_TYPE = "type";
    private static final String KEY_THANKS_LIST = "thanks_list";
    private static final String KEY_SHOW_AT = "show_at";
    private long id;
    private String title;
    private int type;
    private String token;
    private ArrayList<b> questions;
    private i userInteraction;
    private boolean paused = false;
    private ArrayList<c> thankYouItems;
    private com.instabug.survey.e.c.b localization;

    public Survey() {
        i i2;
        com.instabug.survey.e.c.b b2;
        Serializable this_ = b2;
        b2 = new com.instabug.survey.e.c.b();
        v1.localization = this_;
        this_ = i2;
        i2 = new i(0);
        v1.userInteraction = this_;
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject response) throws JSONException {
        ArrayList<Survey> arrayList;
        JSONObject jSONObject = response.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>(jSONObject.length());
        for (int k = 0; k < jSONObject.length(); ++k) {
            Survey survey;
            Survey survey2 = survey;
            survey2();
            survey.setId(jSONObject.getLong(k));
            survey.setPaused(true);
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    public static List<Survey> fromJson(JSONObject surveysJsonObject) throws JSONException {
        ArrayList<Survey> arrayList;
        JSONObject jSONObject = surveysJsonObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList2 = arrayList;
        arrayList = new ArrayList<Survey>();
        for (int k = 0; k < jSONObject.length(); ++k) {
            JSONObject jSONObject2 = jSONObject.getJSONObject(k);
            Survey survey = new Survey();
            survey.fromJson(jSONObject2.toString());
            arrayList2.add(survey);
        }
        return arrayList2;
    }

    private boolean hasNPSSubmitted() {
        if (((Survey)((Object)this_)).userInteraction.i().a() != null) {
            Iterator<a> this_ = ((Survey)((Object)this_)).userInteraction.i().a().iterator();
            while (this_.hasNext()) {
                if (((a)this_.next()).a() != a.a.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPromoter() {
        return this.getNPSAnswerValue() > 8;
    }

    private boolean isPassive() {
        return this.getNPSAnswerValue() > 6 && this.getNPSAnswerValue() <= 8;
    }

    private boolean isDetractor() {
        return this.getNPSAnswerValue() <= 6;
    }

    private int getNPSAnswerValue() {
        try {
            return Integer.parseInt(((b)ListUtils.safeGet(this.questions, (int)0)).a());
        }
        catch (Exception exception) {
            InstabugSDKLogger.e((Object)this, (String)("NPS score parsing failed du to: " + exception.getMessage()));
            return 0;
        }
    }

    private String getNPSThankYouTitle() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).c();
            }
            if (this.isPassive() && c2 != null) {
                return c2.c();
            }
            if (this.isDetractor() && c3 != null) {
                return c3.c();
            }
        }
        return null;
    }

    private String getCustomThankYouTitle() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (c)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((c)this).c();
        }
        return null;
    }

    private String getNPSThankYouMessage() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            c c3 = (c)ListUtils.safeGet(arrayList, (int)2);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).b();
            }
            if (this.isPassive() && c2 != null) {
                return c2.b();
            }
            if (this.isDetractor() && c3 != null) {
                return c3.b();
            }
        }
        return null;
    }

    private String getCustomThankYouMessage() {
        if (((ArrayList)(this = ((Survey)this).getThankYouItems())).size() > 0 && (this = (c)ListUtils.safeGet((List)((Object)this), (int)0)) != null) {
            return ((c)this).b();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void setSessionCounter(int sessionCounter) {
        void var1_1;
        this.userInteraction.c((int)var1_1);
    }

    public g getTarget() {
        return this.userInteraction.i();
    }

    /*
     * WARNING - void declaration
     */
    public void setTarget(g target) {
        void var1_1;
        this.userInteraction.a((g)var1_1);
    }

    public boolean isPaused() {
        return this.paused;
    }

    /*
     * WARNING - void declaration
     */
    public void setPaused(boolean paused) {
        void var1_1;
        this.paused = var1_1;
    }

    @Override
    public long getSurveyId() {
        return this.id;
    }

    @Override
    public i getUserInteraction() {
        return this.userInteraction;
    }

    /*
     * WARNING - void declaration
     */
    public void setUserInteraction(i userInteraction) {
        void var1_1;
        this.userInteraction = var1_1;
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public void setType(int type) {
        void var1_1;
        this.type = var1_1;
    }

    public String getTitle() {
        return this.title;
    }

    /*
     * WARNING - void declaration
     */
    public void setTitle(String title) {
        void var1_1;
        this.title = var1_1;
    }

    public void setSubmitted() {
        a a2;
        Survey survey = this_;
        survey.setCancelled(false);
        survey.setAnswered(true);
        if (survey.isNPSSurvey() && this_.isAnswered() && this_.hasNPSSubmitted() && this_.hasPositiveNpsAnswer()) {
            a a3;
            a2 = a3;
            a.a a4 = a.a.RATE;
            long l = TimeUtils.currentTimeSeconds();
            int n = this_.getEventIndex();
            a3 = new a(a4, l, n);
        } else {
            a a5;
            a2 = a5;
            a.a a6 = a.a.SUBMIT;
            long l = TimeUtils.currentTimeSeconds();
            int n = this_.getEventIndex();
            a5 = new a(a6, l, n);
            if (this_.isOptInSurvey()) {
                this_.userInteraction.a(0);
            }
        }
        Survey survey2 = this_;
        survey2.setSurveyState(f.READY_TO_SEND);
        Cacheable this_ = survey2.userInteraction.i();
        if (this_.a().size() > 0 && this_.a().get(this_.a().size() - 1).a() == a.a.SUBMIT && a2.a() == a.a.SUBMIT) {
            return;
        }
        this_.a().add(a2);
    }

    public boolean isNPSSurvey() {
        return this.getType() == 1;
    }

    public boolean isStoreRatingSurvey() {
        return this.getType() == 2;
    }

    public ArrayList<b> getQuestions() {
        return this.questions;
    }

    /*
     * WARNING - void declaration
     */
    public void setQuestions(ArrayList<b> question) {
        void var1_1;
        this.questions = var1_1;
    }

    public ArrayList<com.instabug.survey.e.c.c> getTargetAudiences() {
        return this.userInteraction.i().e();
    }

    /*
     * WARNING - void declaration
     */
    public void setTargetAudiences(ArrayList<com.instabug.survey.e.c.c> targetAudiences) {
        void var1_1;
        this.userInteraction.i().c((ArrayList<com.instabug.survey.e.c.c>)var1_1);
    }

    public ArrayList<com.instabug.survey.e.c.c> getCustomAttributes() {
        return this.userInteraction.i().c();
    }

    /*
     * WARNING - void declaration
     */
    public void setCustomAttributes(ArrayList<com.instabug.survey.e.c.c> customAttributes) {
        void var1_1;
        this.userInteraction.i().b((ArrayList<com.instabug.survey.e.c.c>)var1_1);
    }

    public ArrayList<com.instabug.survey.e.c.c> getUserEvents() {
        return this.userInteraction.i().g();
    }

    /*
     * WARNING - void declaration
     */
    public void setUserEvents(ArrayList<com.instabug.survey.e.c.c> userEvents) {
        void var1_1;
        this.userInteraction.i().d((ArrayList<com.instabug.survey.e.c.c>)var1_1);
    }

    public ArrayList<a> getSurveyEvents() {
        return this.userInteraction.i().a();
    }

    /*
     * WARNING - void declaration
     */
    public void setSurveyEvents(ArrayList<a> actionEvents) {
        void var1_1;
        this.userInteraction.i().a((ArrayList<a>)var1_1);
    }

    public String getConditionsOperator() {
        return this.userInteraction.i().b();
    }

    /*
     * WARNING - void declaration
     */
    public void setConditionsOperator(String conditionOperator) {
        void var1_1;
        this.userInteraction.i().a((String)var1_1);
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && (this.isPromoter() || this.isPassive());
    }

    public int getEventIndex() {
        return this.userInteraction.d();
    }

    /*
     * WARNING - void declaration
     */
    public void setEventIndex(int eventIndex) {
        void var1_1;
        this.userInteraction.b((int)var1_1);
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    public String getToken() {
        return this.token;
    }

    /*
     * WARNING - void declaration
     */
    public void setToken(String token) {
        void var1_1;
        this.token = var1_1;
    }

    public void setDismissed() {
        a a2;
        Survey survey = this_;
        survey.setSurveyState(f.READY_TO_SEND);
        if (survey.isNPSSurvey() && this_.hasPositiveNpsAnswer() && this_.hasNPSSubmitted()) {
            return;
        }
        boolean bl = this_.isOptInSurvey() || this_.userInteraction.c() == 0L;
        Survey survey2 = this_;
        survey2.setShouldShowAgain(bl);
        survey2.userInteraction.a(TimeUtils.currentTimeSeconds());
        survey2.setCancelled(true);
        if (survey2.userInteraction.i().a().size() > 0 && this_.userInteraction.i().a().get(this_.userInteraction.i().a().size() - 1).a() == a.a.DISMISS) {
            return;
        }
        Survey survey3 = this_;
        a a3 = a2;
        Survey survey4 = this_;
        Object this_ = a.a.DISMISS;
        long l = survey4.userInteraction.c();
        int n = survey4.getEventIndex();
        a2 = new a((a.a)((Object)this_), l, n);
        survey3.userInteraction.i().a().add(a3);
    }

    public void addShowEvent() {
        a a2;
        Survey survey = this;
        survey.userInteraction.b(TimeUtils.currentTimeSeconds());
        survey.userInteraction.k();
        a a3 = a2;
        Survey survey2 = this;
        long l = survey2.userInteraction.f();
        int n = survey2.userInteraction.l();
        a2 = new a(a.a.SHOW, l, n);
        survey.userInteraction.i().a().add(a3);
    }

    public void addRateEvent() {
        a a2;
        Survey survey = this_;
        a a3 = a2;
        Survey survey2 = this_;
        Object this_ = a.a.RATE;
        long l = TimeUtils.currentTimeSeconds();
        int n = survey2.getAttemptCount();
        a2 = new a((a.a)((Object)this_), l, n);
        survey.userInteraction.i().a().add(a3);
    }

    public long getShownAt() {
        return this.userInteraction.f();
    }

    /*
     * WARNING - void declaration
     */
    public void setShowAt(long shownAt) {
        void var1_1;
        this.userInteraction.b((long)var1_1);
    }

    public int getAttemptCount() {
        return this.userInteraction.b();
    }

    /*
     * WARNING - void declaration
     */
    public void setAttemptCount(int attemptsCount) {
        void var1_1;
        this.userInteraction.a((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSessionCount(int sessionCount) {
        void var1_1;
        this.userInteraction.c((int)var1_1);
    }

    @Nullable
    public String getThankYouTitle() {
        return this.isNPSSurvey() ? this.getNPSThankYouTitle() : this.getCustomThankYouTitle();
    }

    @Nullable
    public String getThankYouMessage() {
        return this.isNPSSurvey() ? this.getNPSThankYouMessage() : this.getCustomThankYouMessage();
    }

    public boolean isAppStoreRatingEnabled() {
        Serializable serializable = this.getThankYouItems();
        if (((ArrayList)serializable).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).d();
            }
            if (this.isPassive() && c2 != null) {
                return c2.d();
            }
        }
        return false;
    }

    @Nullable
    public String getRatingCTATitle() {
        Serializable serializable;
        if (this.isAppStoreRatingEnabled() && ((ArrayList)(serializable = this.getThankYouItems())).size() > 0) {
            ArrayList<c> arrayList = serializable;
            serializable = (c)ListUtils.safeGet(arrayList, (int)0);
            c c2 = (c)ListUtils.safeGet(arrayList, (int)1);
            if (this.isPromoter() && serializable != null) {
                return ((c)serializable).a();
            }
            if (this.isPassive() && c2 != null) {
                return c2.a();
            }
        }
        return null;
    }

    public void incrementSessionCount() {
        this.userInteraction.m();
    }

    public boolean isCancelled() {
        return this.userInteraction.p();
    }

    /*
     * WARNING - void declaration
     */
    public void setCancelled(boolean cancelled) {
        void var1_1;
        this.userInteraction.c((boolean)var1_1);
    }

    public void resetSessionsCounter() {
        this.userInteraction.c(0);
    }

    public void resetUserInteractions() {
        i i2;
        i i3;
        g g2 = this.userInteraction.i();
        g2.a(new ArrayList<a>());
        i i4 = i3 = i2;
        i4(0);
        this.userInteraction = i4;
        i2.a(g2);
    }

    public void resetUserAnswers() {
        Iterator<b> this_ = ((Survey)((Object)this_)).questions.iterator();
        while (this_.hasNext()) {
            ((b)this_.next()).g();
        }
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0) {
            for (a a2 : this.userInteraction.i().a()) {
                if (a2.a() != a.a.SUBMIT) continue;
                return a2.c();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int k = this.getQuestions().size() - 1; k >= 0; --k) {
                if (this.getQuestions().get(k).b() <= 0L) continue;
                return this.getQuestions().get(k).b();
            }
        }
        return 0L;
    }

    public boolean isLastEventDismiss() {
        return this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0 && this.userInteraction.i().a().get(this.userInteraction.i().a().size() - 1).a() == a.a.DISMISS;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2 = jSONObject;
        jSONObject2();
        long l = this.id;
        JSONObject jSONObject3 = jSONObject2.put(KEY_ID, l).put(KEY_TYPE, this.type).put(KEY_TITLE, (Object)this.title).put(KEY_TOKEN, (Object)this.token).put(KEY_QUESTIONS, (Object)b.b(this.questions)).put(KEY_TARGET, (Object)g.a(this.userInteraction.i())).put(KEY_SURVEY_EVENTS, (Object)a.a(this.userInteraction.i().a())).put(KEY_ANSWERED, this.userInteraction.o());
        l = this.userInteraction.f();
        JSONObject jSONObject4 = jSONObject3.put(KEY_SHOW_AT, l);
        l = this.getDismissedAt();
        jSONObject4.put(KEY_DISMISSED_AT, l).put(KEY_IS_CANCELLED, this.userInteraction.p()).put(KEY_SURVEY_STATE, (Object)this.getSurveyState().toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_THANKS_LIST, (Object)c.a(this.thankYouItems)).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        this.localization.b(jSONObject2);
        return jSONObject.toString();
    }

    public boolean shouldShowAgain() {
        return this.userInteraction.q();
    }

    public long getDismissedAt() {
        return this.userInteraction.c();
    }

    /*
     * WARNING - void declaration
     */
    public void setDismissedAt(long dismissedAt) {
        void var1_1;
        this.userInteraction.a((long)var1_1);
    }

    public f getSurveyState() {
        return this.userInteraction.h();
    }

    /*
     * WARNING - void declaration
     */
    public void setSurveyState(f surveyState) {
        void var1_1;
        this.userInteraction.a((f)var1_1);
    }

    public int getSessionCounter() {
        return this.userInteraction.e();
    }

    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        if (new JSONObject((String)jSONObject).has(KEY_ID)) {
            this.setId(jSONObject3.getLong(KEY_ID));
        }
        if (jSONObject3.has(KEY_TYPE)) {
            this.setType(jSONObject3.getInt(KEY_TYPE));
        }
        if (jSONObject3.has(KEY_TITLE)) {
            this.setTitle(jSONObject3.getString(KEY_TITLE));
        }
        if (jSONObject3.has(KEY_TOKEN) && jSONObject3.get(KEY_TOKEN) != JSONObject.NULL) {
            this.setToken(jSONObject3.getString(KEY_TOKEN));
        }
        if (jSONObject3.has(KEY_SURVEY_EVENTS)) {
            this.userInteraction.i().a(a.a(jSONObject3.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject3.has(KEY_QUESTIONS)) {
            this.setQuestions(b.a(jSONObject3.getJSONArray(KEY_QUESTIONS)));
        }
        if (jSONObject3.has(KEY_TARGET)) {
            jSONObject = jSONObject3.getJSONObject(KEY_TARGET);
            this.userInteraction.i().fromJson(jSONObject.toString().replace("\\", ""));
        }
        if (jSONObject3.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject3.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject3.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject3.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject3.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(f.valueOf(jSONObject3.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject3.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject3.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject3.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject3.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject3.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject3.getInt(KEY_DISMISSED_AT));
        }
        if (jSONObject3.has(KEY_SHOW_AT)) {
            this.setShowAt(jSONObject3.getInt(KEY_SHOW_AT));
        }
        if (jSONObject3.has(KEY_THANKS_LIST)) {
            this.setThankYouItems(c.a(jSONObject3.getJSONArray(KEY_THANKS_LIST)));
        }
        this.localization.a(jSONObject3);
    }

    public long getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    public Survey setId(long id2) {
        void var1_1;
        this.id = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void setThankYouItems(ArrayList<c> thankYouItems) {
        void var1_1;
        this.thankYouItems = var1_1;
    }

    public ArrayList<c> getThankYouItems() {
        return this.thankYouItems;
    }

    public boolean isAnswered() {
        return this.userInteraction.o();
    }

    /*
     * WARNING - void declaration
     */
    public void setAnswered(boolean answered) {
        void var1_1;
        this.userInteraction.b((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setShouldShowAgain(boolean shouldShowAgain) {
        void var1_1;
        this.userInteraction.d((boolean)var1_1);
    }

    public com.instabug.survey.e.c.b getLocalization() {
        return this.localization;
    }

    /*
     * WARNING - void declaration
     */
    public void setLocalization(com.instabug.survey.e.c.b localization) {
        void var1_1;
        this.localization = var1_1;
    }

    public void clearAnswers() {
        Iterator<b> this_ = ((Survey)((Object)this_)).questions.iterator();
        while (this_.hasNext()) {
            ((b)this_.next()).a((String)null);
        }
    }

    public boolean isLastEventSubmit() {
        return this.userInteraction.i().a() != null && this.userInteraction.i().a().size() > 0 && this.userInteraction.i().a().get(this.userInteraction.i().a().size() - 1).a() == a.a.SUBMIT;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object survey) {
        if (survey instanceof Survey) {
            void var1_1;
            return ((Survey)var1_1).getId() == this.getId();
        }
        return false;
    }

    @NonNull
    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e((Object)"Survey", (String)jSONException.getMessage(), (Throwable)jSONException);
            return super.toString();
        }
    }

    public boolean shouldShow() {
        Survey survey = this;
        g g2 = survey.userInteraction.i();
        boolean bl = g2.d().c();
        boolean bl2 = this.userInteraction.n() ^ true;
        boolean bl3 = g2.d().d() ^ true;
        boolean bl4 = com.instabug.survey.h.a.b(survey.getShownAt()) >= g2.d().a();
        return bl || bl2 || bl3 && bl4;
    }
}

