/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import com.instabug.library.Feature;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEvent;
import com.instabug.library.core.eventbus.coreeventbus.SDKCoreEventSubscriber;
import com.instabug.library.core.plugin.Plugin;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.OnDiskCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.threading.PoolProvider;
import com.instabug.survey.a.a;
import com.instabug.survey.a.c;
import com.instabug.survey.announcements.network.InstabugAnnouncementSubmitterService;
import com.instabug.survey.b;
import com.instabug.survey.b.d;
import com.instabug.survey.b.f;
import com.instabug.survey.cache.SurveysCacheManager;
import com.instabug.survey.models.Survey;
import com.instabug.survey.network.service.InstabugSurveysSubmitterService;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.Locale;

public class SurveyPlugin
extends Plugin {
    private Disposable subscribe;
    private Disposable userTypeDisposable;
    private com.instabug.survey.announcements.a announcementManager;

    public void init(Context context) {
        super.init(context);
        com.instabug.survey.a.b.a(context);
        a.a();
        this.subscribeOnSDKEvents();
        this.initAnnouncementSettings(context);
    }

    private void initAnnouncementSettings(Context context) {
        this.announcementManager = com.instabug.survey.announcements.a.a(context);
        com.instabug.survey.announcements.b.b.a(context);
    }

    public void wake() {
        this.migrateOldSurveysCacheToDb();
        b.a();
        b.b().e();
        com.instabug.survey.models.a a2 = new com.instabug.survey.models.a();
        this.resolveCountryInfo(a2);
        this.startFetchingAnnouncements(this.getLocaleResolved());
        this.startFetchingSurveys(this.getLocaleResolved());
        this.checkAppStatus();
        this.startSubmittingPendingSurveys();
        this.startSubmittingPendingAnnouncements();
        this.userTypeDisposable = SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                if (sDKCoreEvent.getType().equals("user") && sDKCoreEvent.getValue().equals("logged_out")) {
                    b.b().h();
                    com.instabug.survey.announcements.a.a((Context)SurveyPlugin.this.contextWeakReference.get()).c();
                } else if (sDKCoreEvent.getType().equals("user") && sDKCoreEvent.getValue().equals("logged_in")) {
                    b.b().i();
                    com.instabug.survey.announcements.a.a((Context)SurveyPlugin.this.contextWeakReference.get()).d();
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((SDKCoreEvent)object);
            }
        });
    }

    public void sleep() {
        this.announcementManager.b();
        b.b().g();
        if (this.userTypeDisposable != null) {
            this.userTypeDisposable.dispose();
        }
    }

    public void release() {
        if (this.subscribe != null) {
            this.subscribe.dispose();
        }
    }

    public long getLastActivityTime() {
        return com.instabug.survey.a.b.a().b();
    }

    public void onLocaleChanged(Locale oldLocale, Locale newLocale) {
        super.onLocaleChanged(oldLocale, newLocale);
        if (this.shouldReFetch()) {
            String string2 = LocaleUtils.resolveLocale((Context)this.getAppContext(), (Locale)newLocale);
            this.startFetchingAnnouncements(string2);
            this.startFetchingSurveys(string2);
        }
    }

    @VisibleForTesting
    void subscribeOnSDKEvents() {
        this.subscribe = SDKCoreEventSubscriber.subscribe((Consumer)new Consumer<SDKCoreEvent>(){

            public void a(SDKCoreEvent sDKCoreEvent) {
                if (f.b()) {
                    switch (sDKCoreEvent.getType()) {
                        case "user": {
                            if (!sDKCoreEvent.getValue().equals("logged_out")) break;
                            SurveyPlugin.clearUserActivities();
                            break;
                        }
                        case "features": {
                            if (!sDKCoreEvent.getValue().equals("fetched")) break;
                            SurveyPlugin.this.startFetchingSurveys(SurveyPlugin.this.getLocaleResolved());
                            break;
                        }
                        case "network": {
                            if (!sDKCoreEvent.getValue().equals("activated")) break;
                            SurveyPlugin.this.startSubmittingPendingSurveys();
                            SurveyPlugin.this.startSubmittingPendingAnnouncements();
                            break;
                        }
                    }
                }
            }

            public /* synthetic */ void accept(Object object) throws Exception {
                this.a((SDKCoreEvent)object);
            }
        });
    }

    private void startSubmittingPendingAnnouncements() {
        if (InstabugCore.getFeatureState((Feature)Feature.ANNOUNCEMENTS) == Feature.State.ENABLED) {
            HandlerThread handlerThread = new HandlerThread("submit-announcement-handler");
            handlerThread.start();
            Looper looper = handlerThread.getLooper();
            Handler handler = new Handler(looper);
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Context context;
                    if (SurveyPlugin.this.contextWeakReference != null && (context = (Context)SurveyPlugin.this.contextWeakReference.get()) != null) {
                        InstabugAnnouncementSubmitterService.a(context, new Intent(context, InstabugAnnouncementSubmitterService.class));
                    }
                }
            });
        }
    }

    @VisibleForTesting
    void resolveCountryInfo(com.instabug.survey.models.a countryInfo) {
        if (f.a() && this.contextWeakReference != null && this.contextWeakReference.get() != null) {
            InstabugSDKLogger.d((Object)((Object)this), (String)"Getting Country Code...");
            b.b().a(countryInfo);
        }
    }

    private void startSubmittingPendingSurveys() {
        if (f.a() && f.b()) {
            HandlerThread handlerThread = new HandlerThread("submit-surveys-handler");
            handlerThread.start();
            Looper looper = handlerThread.getLooper();
            Handler handler = new Handler(looper);
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Context context;
                    if (SurveyPlugin.this.contextWeakReference != null && (context = (Context)SurveyPlugin.this.contextWeakReference.get()) != null) {
                        InstabugSurveysSubmitterService.a(context, new Intent(context, InstabugSurveysSubmitterService.class));
                    }
                }
            });
        }
    }

    private static void clearUserActivities() {
        com.instabug.survey.a.b.a().a(0L);
        com.instabug.survey.a.b.a().c(0L);
    }

    private void migrateOldSurveysCacheToDb() {
        PoolProvider.postIOTask((Runnable)new Runnable(){

            @Override
            public void run() {
                InstabugSDKLogger.v((Object)this, (String)"Creating Surveys disk cache");
                if (SurveyPlugin.this.contextWeakReference != null && SurveyPlugin.this.contextWeakReference.get() != null) {
                    OnDiskCache onDiskCache = new OnDiskCache((Context)SurveyPlugin.this.contextWeakReference.get(), "surveys_disk_cache", "/surveys.cache", Survey.class);
                    CacheManager.getInstance().addCache((Cache)onDiskCache);
                    boolean bl = CacheManager.getInstance().cacheExists(onDiskCache.getId());
                    if (bl) {
                        SurveysCacheManager.migrateOldCacheToDb();
                    }
                }
            }
        });
    }

    private void checkAppStatus() {
        Context context = (Context)this.contextWeakReference.get();
        if (context != null) {
            d.b(context);
        }
    }

    @VisibleForTesting
    void startFetchingSurveys(String locale) {
        if (f.b() && this.contextWeakReference != null && this.contextWeakReference.get() != null) {
            InstabugSDKLogger.v((Object)((Object)this), (String)"initialize Instabug Surveys Manager");
            b.b().a(locale);
        }
    }

    @VisibleForTesting
    void startFetchingAnnouncements(String locale) {
        if (this.contextWeakReference != null && this.contextWeakReference.get() != null && InstabugCore.getFeatureState((Feature)Feature.ANNOUNCEMENTS) == Feature.State.ENABLED) {
            InstabugSDKLogger.v((Object)((Object)this), (String)"initialize Instabug Announcement Manager");
            com.instabug.survey.announcements.a.a((Context)this.contextWeakReference.get()).a(locale);
        }
    }

    private String getLocaleResolved() {
        return LocaleUtils.getCurrentLocaleResolved((Context)this.getAppContext());
    }

    @VisibleForTesting
    boolean shouldReFetch() {
        return !this.getLocaleResolved().equals(c.j());
    }
}

