/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.models;

import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.models.a;
import com.instabug.survey.models.b;
import com.instabug.survey.models.c;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Survey
implements Cacheable,
Serializable {
    private static final String KEY_PUBLISHED = "published";
    private static final String KEY_PAUSED = "paused";
    private static final String KEY_ID = "id";
    private static final String KEY_TITLE = "title";
    private static final String KEY_TOKEN = "token";
    private static final String HAS_RESPOND = "has_respond";
    @Deprecated
    private static final String KEY_QUESTION_DEPRECATED = "question";
    @Deprecated
    private static final String KEY_SUBMITTED = "submitted";
    private static final String KEY_QUESTIONS = "questions";
    private static final String KEY_TARGET = "target";
    private static final String KEY_TARGET_AUDIENCE = "primitive_types";
    private static final String KEY_CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String KEY_USER_EVENTS = "user_events";
    private static final String KEY_CONDITIONS_OPERATOR = "operator";
    private static final String KEY_ANSWERED = "answered";
    private static final String KEY_DISMISSED_AT = "dismissed_at";
    private static final String KEY_IS_CANCELLED = "is_cancelled";
    private static final String KEY_SURVEY_EVENTS = "events";
    private static final String KEY_SURVEY_STATE = "survey_state";
    private static final String KEY_SHOULD_SHOW_AGAIN = "should_show_again";
    private static final String KEY_SESSION_COUNTER = "session_counter";
    private static final String KEY_WELCOME_SCREEN = "welcome_screen";
    private long id;
    private String title;
    private String token;
    private ArrayList<b> questions;
    private ArrayList<a> targetAudiences = new ArrayList();
    private ArrayList<a> customAttributes = new ArrayList();
    private ArrayList<a> userEvents;
    private ArrayList<c> surveyEvents = new ArrayList();
    private String conditionsOperator = "and";
    private boolean answered = false;
    private long dismissedAt;
    private boolean isCancelled = false;
    private int attemptCount = -1;
    private int eventIndex = -1;
    private SurveyState surveyState = SurveyState.NOT_AVAILABLE;
    private boolean shouldShowAgain = true;
    private boolean paused = false;
    private int sessionCounter = 0;

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
    }

    public static List<Survey> getPausedSurveysFromJson(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray(KEY_PAUSED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>(jSONArray.length());
        for (int i = 0; i < jSONArray.length(); ++i) {
            Survey survey = new Survey();
            survey.setId(jSONArray.getLong(i));
            survey.setPaused(true);
            arrayList.add(survey);
        }
        return arrayList;
    }

    public int incrementEventIndex() {
        ++this.attemptCount;
        return ++this.eventIndex;
    }

    public static List<Survey> fromJson(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray = jSONObject.getJSONArray(KEY_PUBLISHED);
        ArrayList<Survey> arrayList = new ArrayList<Survey>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject2 = jSONArray.getJSONObject(i);
            Survey survey = new Survey();
            survey.fromJson(jSONObject2.toString());
            arrayList.add(survey);
        }
        return arrayList;
    }

    public long getId() {
        return this.id;
    }

    public Survey setId(long l) {
        this.id = l;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string2) {
        this.title = string2;
    }

    public ArrayList<b> getQuestions() {
        return this.questions;
    }

    public void setQuestions(ArrayList<b> arrayList) {
        this.questions = arrayList;
    }

    public ArrayList<a> getTargetAudiences() {
        return this.targetAudiences;
    }

    public void setTargetAudiences(ArrayList<a> arrayList) {
        this.targetAudiences = arrayList;
    }

    public ArrayList<a> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(ArrayList<a> arrayList) {
        this.customAttributes = arrayList;
    }

    public ArrayList<a> getUserEvents() {
        return this.userEvents;
    }

    public void setUserEvents(ArrayList<a> arrayList) {
        this.userEvents = arrayList;
    }

    public String getConditionsOperator() {
        return this.conditionsOperator;
    }

    public void setConditionsOperator(String string2) {
        this.conditionsOperator = string2;
    }

    public boolean isAnswered() {
        return this.answered;
    }

    public void setAnswered(boolean bl) {
        this.answered = bl;
    }

    public boolean shouldShowAgain() {
        return this.shouldShowAgain;
    }

    public void setShouldShowAgain(boolean bl) {
        this.shouldShowAgain = bl;
    }

    public void setSubmitted() {
        c c2;
        this.setCancelled(false);
        this.setAnswered(true);
        if (this.isOptInSurvey()) {
            this.setShouldShowAgain(true);
        } else {
            this.setShouldShowAgain(false);
        }
        if (this.isNPSSurvey() && this.isAnswered() && this.hasNPSSubmitted() && this.hasPositiveNpsAnswer() && this.isLifeVersion()) {
            c2 = new c(c.a.RATE, System.currentTimeMillis() / 1000L, this.getEventIndex());
        } else {
            c2 = new c(c.a.SUBMIT, System.currentTimeMillis() / 1000L, this.getEventIndex());
            if (this.isOptInSurvey()) {
                this.attemptCount = 0;
            }
        }
        this.setSurveyState(SurveyState.READY_TO_SEND);
        if (this.getSurveyEvents().size() > 0 && this.getSurveyEvents().get((int)(this.getSurveyEvents().size() - 1)).a == c.a.SUBMIT && c2.a == c.a.SUBMIT) {
            return;
        }
        this.getSurveyEvents().add(c2);
    }

    public boolean isLifeVersion() {
        return this.questions != null && this.questions.size() == 3;
    }

    public boolean isNPSSurvey() {
        return this.getQuestions() != null && this.getQuestions().size() > 0 && this.getQuestions().get(0).c() == b.a.NPS;
    }

    public boolean hasPositiveNpsAnswer() {
        return this.isNPSSurvey() && this.getQuestions().get(0).e() != null && (this.getQuestions().get(0).e().equals("9") || this.getQuestions().get(0).e().equals("10"));
    }

    private boolean hasNPSSubmitted() {
        if (this.getSurveyEvents() != null) {
            for (c c2 : this.getSurveyEvents()) {
                if (c2.a() != c.a.SUBMIT) continue;
                return true;
            }
        }
        return false;
    }

    public void setDismissed() {
        this.setSurveyState(SurveyState.READY_TO_SEND);
        if (this.isNPSSurvey() && this.hasPositiveNpsAnswer() && this.hasNPSSubmitted()) {
            return;
        }
        this.dismissedAt = System.currentTimeMillis() / 1000L;
        this.setCancelled(true);
        if (this.getSurveyEvents().size() > 0 && this.getSurveyEvents().get((int)(this.getSurveyEvents().size() - 1)).a == c.a.DISMISS) {
            return;
        }
        c c2 = new c(c.a.DISMISS, this.dismissedAt, this.getEventIndex());
        this.getSurveyEvents().add(c2);
    }

    public void addShowEvent() {
        c c2 = new c(c.a.SHOW, System.currentTimeMillis() / 1000L, this.incrementEventIndex());
        this.getSurveyEvents().add(c2);
    }

    private int getAttempt() {
        return this.attemptCount++;
    }

    private int getEventIndex() {
        return this.eventIndex;
    }

    public boolean isPromoter() {
        return this.questions.get(0).e() != null && (this.questions.get(0).e().equals("9") || this.questions.get(0).e().equals("10"));
    }

    public long getDismissedAt() {
        return this.dismissedAt;
    }

    public void setToken(String string2) {
        this.token = string2;
    }

    public String getToken() {
        return this.token;
    }

    public void setCancelled(boolean bl) {
        this.isCancelled = bl;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public ArrayList<c> getSurveyEvents() {
        return this.surveyEvents;
    }

    public void setSurveyEvents(ArrayList<c> arrayList) {
        this.surveyEvents = arrayList;
    }

    public SurveyState getSurveyState() {
        return this.surveyState;
    }

    public void setSurveyState(SurveyState surveyState) {
        this.surveyState = surveyState;
    }

    private void setSessionCounter(int n) {
        this.sessionCounter = n;
    }

    public int getSessionCounter() {
        return this.sessionCounter;
    }

    public void incrementSessionCount() {
        this.setSessionCounter(++this.sessionCounter);
    }

    public void resetSessionsCounter() {
        this.sessionCounter = 0;
    }

    public void setDismissedAt(long l) {
        this.dismissedAt = l;
    }

    public boolean isOptInSurvey() {
        return this.getToken() != null && !String.valueOf(this.getToken()).equals("null");
    }

    public long getRespondedAt() {
        if (this.isLastEventDismiss()) {
            return 0L;
        }
        if (this.getSurveyEvents() != null && this.getSurveyEvents().size() > 0) {
            for (c c2 : this.getSurveyEvents()) {
                if (c2.a() != c.a.SUBMIT) continue;
                return c2.b();
            }
        }
        if (this.getQuestions() != null && this.getQuestions().size() > 0) {
            for (int i = this.getQuestions().size() - 1; i >= 0; --i) {
                if (this.getQuestions().get(i).f() <= 0L) continue;
                return this.getQuestions().get(i).f();
            }
        }
        return 0L;
    }

    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_ID, this.id).put(KEY_TITLE, (Object)this.title).put(KEY_TOKEN, (Object)this.token).put(KEY_QUESTIONS, (Object)b.a(this.questions)).put(KEY_TARGET, (Object)new JSONObject().put(KEY_TARGET_AUDIENCE, (Object)a.a(this.targetAudiences)).put(KEY_CUSTOM_ATTRIBUTES, (Object)a.a(this.customAttributes)).put(KEY_USER_EVENTS, (Object)a.a(this.userEvents)).put(KEY_CONDITIONS_OPERATOR, (Object)this.conditionsOperator)).put(KEY_SURVEY_EVENTS, (Object)c.a(this.surveyEvents)).put(KEY_ANSWERED, this.answered).put(KEY_DISMISSED_AT, this.getDismissedAt()).put(KEY_IS_CANCELLED, this.isCancelled).put(KEY_SURVEY_STATE, (Object)this.getSurveyState().toString()).put(KEY_SHOULD_SHOW_AGAIN, this.shouldShowAgain()).put(KEY_SESSION_COUNTER, this.getSessionCounter());
        return jSONObject.toString();
    }

    public void fromJson(String string2) throws JSONException {
        b b2;
        JSONObject jSONObject = new JSONObject(string2);
        if (jSONObject.has(KEY_ID)) {
            this.setId(jSONObject.getLong(KEY_ID));
        }
        if (jSONObject.has(KEY_TITLE)) {
            this.setTitle(jSONObject.getString(KEY_TITLE));
        }
        if (jSONObject.has(KEY_TOKEN)) {
            this.setToken(jSONObject.getString(KEY_TOKEN));
        }
        if (jSONObject.has(KEY_SURVEY_EVENTS)) {
            this.setSurveyEvents(c.a(jSONObject.getJSONArray(KEY_SURVEY_EVENTS)));
        }
        if (jSONObject.has(KEY_QUESTIONS)) {
            this.setQuestions(b.a(jSONObject.getJSONArray(KEY_QUESTIONS)));
        } else if (jSONObject.has(KEY_QUESTION_DEPRECATED)) {
            InstabugSDKLogger.d((Object)this, (String)"Migrating old surveys");
            b2 = new b();
            b2.a(this.getId());
            b2.fromJson(jSONObject.get(KEY_QUESTION_DEPRECATED).toString());
            ArrayList<b> arrayList = new ArrayList<b>();
            arrayList.add(b2);
            this.setQuestions(arrayList);
        }
        if (jSONObject.has(KEY_TARGET)) {
            b2 = jSONObject.getJSONObject(KEY_TARGET);
            if (b2.has(KEY_TARGET_AUDIENCE)) {
                this.setTargetAudiences(a.a(b2.getJSONArray(KEY_TARGET_AUDIENCE)));
            }
            if (b2.has(KEY_CUSTOM_ATTRIBUTES)) {
                this.setCustomAttributes(a.a(b2.getJSONArray(KEY_CUSTOM_ATTRIBUTES)));
            }
            if (b2.has(KEY_USER_EVENTS)) {
                this.setUserEvents(a.a(b2.getJSONArray(KEY_USER_EVENTS)));
            }
            if (b2.has(KEY_CONDITIONS_OPERATOR)) {
                this.setConditionsOperator(b2.getString(KEY_CONDITIONS_OPERATOR));
            }
        }
        if (jSONObject.has(KEY_ANSWERED)) {
            this.setAnswered(jSONObject.getBoolean(KEY_ANSWERED));
        }
        if (jSONObject.has(KEY_SUBMITTED)) {
            boolean bl = jSONObject.getBoolean(KEY_SUBMITTED);
            if (this.isAnswered() && !bl) {
                this.setSurveyState(SurveyState.READY_TO_SEND);
            } else if (this.isAnswered() && bl) {
                this.setSurveyState(SurveyState.SYNCED);
            } else {
                this.setSurveyState(SurveyState.NOT_AVAILABLE);
            }
        }
        if (jSONObject.has(KEY_IS_CANCELLED)) {
            this.setCancelled(jSONObject.getBoolean(KEY_IS_CANCELLED));
        }
        if (jSONObject.has(KEY_SURVEY_STATE)) {
            this.setSurveyState(SurveyState.valueOf(jSONObject.getString(KEY_SURVEY_STATE)));
        }
        if (jSONObject.has(KEY_SHOULD_SHOW_AGAIN)) {
            this.setShouldShowAgain(jSONObject.getBoolean(KEY_SHOULD_SHOW_AGAIN));
        }
        if (jSONObject.has(KEY_SESSION_COUNTER)) {
            this.setSessionCounter(jSONObject.getInt(KEY_SESSION_COUNTER));
        }
        if (jSONObject.has(KEY_DISMISSED_AT)) {
            this.setDismissedAt(jSONObject.getInt(KEY_DISMISSED_AT));
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Survey) {
            Survey survey = (Survey)object;
            return survey.getId() == this.getId();
        }
        return false;
    }

    public void clearAnswers() {
        for (b b2 : this.questions) {
            b2.b((String)null);
        }
    }

    public boolean isLastEventDismiss() {
        return this.surveyEvents != null && this.surveyEvents.size() > 0 && this.surveyEvents.get((int)(this.surveyEvents.size() - 1)).a == c.a.DISMISS;
    }

    public boolean isLastEventSubmit() {
        return this.surveyEvents != null && this.surveyEvents.size() > 0 && this.surveyEvents.get((int)(this.surveyEvents.size() - 1)).a == c.a.SUBMIT;
    }

    public int hashCode() {
        return String.valueOf(this.getId()).hashCode();
    }

    public static enum SurveyState {
        READY_TO_SEND,
        NOT_AVAILABLE,
        SYNCED;

    }
}

