/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.survey.cache;

import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.survey.models.Survey;
import java.util.ArrayList;
import java.util.List;

public class SurveysCacheManager {
    public static final String SURVEYS_DISK_CACHE_FILE_NAME = "/surveys.cache";
    public static final String SURVEYS_DISK_CACHE_KEY = "surveys_disk_cache";
    public static final String SURVEYS_MEMORY_CACHE_KEY = "surveys_memory_cache";

    public static InMemoryCache<Long, Survey> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SURVEYS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache not found, loading it from disk " + CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY)));
            CacheManager.getInstance().migrateCache(SURVEYS_DISK_CACHE_KEY, SURVEYS_MEMORY_CACHE_KEY, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<Long, Survey>(){

                public Long a(Survey survey) {
                    return survey.b();
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Survey)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("In-memory Surveys cache restored from disk, " + cache.size() + " elements restored"));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)"In-memory Surveys cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Cache cache = CacheManager.getInstance().getCache(SURVEYS_DISK_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(SURVEYS_MEMORY_CACHE_KEY);
        if (cache != null && cache2 != null) {
            CacheManager.getInstance().migrateCache(cache2, cache, (CacheManager.KeyExtractor)new CacheManager.KeyExtractor<String, Survey>(){

                public String a(Survey survey) {
                    return String.valueOf(survey.b());
                }

                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Survey)object);
                }
            });
        }
    }

    public static void addSurvey(Survey survey) {
        InMemoryCache<Long, Survey> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put((Object)survey.b(), (Object)survey);
        }
    }

    public static void addSurveys(List<Survey> list) {
        for (Survey survey : list) {
            SurveysCacheManager.addSurvey(survey);
        }
    }

    public static List<Survey> getSurveys() {
        InMemoryCache<Long, Survey> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<Survey>();
    }

    public static List<Survey> getNotAnsweredSurveys() {
        ArrayList<Survey> arrayList = new ArrayList<Survey>();
        InMemoryCache<Long, Survey> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            for (Survey survey : list) {
                if (survey.x() || survey.h() || !survey.i()) continue;
                arrayList.add(survey);
                InstabugSDKLogger.d(SurveysCacheManager.class, (String)("survey id: " + survey.b()));
            }
        }
        InstabugSDKLogger.d(SurveysCacheManager.class, (String)("NotAnsweredSurveys size: " + arrayList.size()));
        return arrayList;
    }

    public static List<Survey> getReadyToSendSurveys() {
        ArrayList<Survey> arrayList = new ArrayList<Survey>();
        InMemoryCache<Long, Survey> inMemoryCache = SurveysCacheManager.getCache();
        if (inMemoryCache != null) {
            List list = inMemoryCache.getValues();
            InstabugSDKLogger.d(SurveysCacheManager.class, (String)("size: " + list.size()));
            for (Survey survey : list) {
                if (survey.t() != Survey.SurveyState.READY_TO_SEND) continue;
                arrayList.add(survey);
            }
        }
        return arrayList;
    }
}

