package com.instabug.survey.utils;

import android.util.TypedValue;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.instabug.library.internal.device.InstabugDeviceProperties;

/**
 * @author hossam.
 */

public class TextSizeCalculator {
    public static void resize(@NonNull final TextView textView) {
        if (InstabugDeviceProperties.isTablet(textView.getContext())) {
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 18);
            textView.setLineSpacing(1f, 1.2f);
            textView.setMaxLines(4);
        } else {
            if (textView.getText().toString().length() > 150) {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 15);
                textView.setLineSpacing(1f, 1.1f);
                textView.setMaxLines(5);
            } else if (textView.getText().toString().length() > 100) {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
                textView.setLineSpacing(1f, 1.2f);
                textView.setMaxLines(4);
            } else if (textView.getText().toString().length() < 150) {
                textView.post(new Runnable() {
                    @Override
                    public void run() {
                        if (textView.getLineCount() > 2) {
                            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 16);
                            textView.setLineSpacing(1f, 1.1f);
                            textView.setMaxLines(2);
                        } else if (textView.getLineCount() > 1) {
                            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 17);
                            textView.setLineSpacing(1f, 1.1f);
                            textView.setMaxLines(2);
                        }
                    }
                });
            } else {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 18);
                textView.setLineSpacing(1f, 1.2f);
                textView.setMaxLines(4);
            }
        }
    }

    public static void resizeRateUsText(final TextView textView) {
        if (InstabugDeviceProperties.isTablet(textView.getContext())) {
            textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 15);
            textView.setLineSpacing(1f, 1.2f);
            textView.setMaxLines(4);
        } else {
            if (textView.getText().toString().length() >= 150) {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 12);
                textView.setLineSpacing(1f, 1.1f);
                textView.setMaxLines(5);
            } else if (textView.getText().toString().length() >= 100) {
                textView.setTextSize(TypedValue.COMPLEX_UNIT_SP, 14);
                textView.setLineSpacing(1f, 1.2f);
                textView.setMaxLines(4);
            }
        }
    }
}
