package com.instabug.survey.ui.survey.thankspage;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;

import com.instabug.library.InstabugColorTheme;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.library.util.AccessibilityUtils;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.LocaleUtils;
import com.instabug.survey.R;
import com.instabug.survey.models.Survey;
import com.instabug.survey.models.SurveyTypes;
import com.instabug.survey.settings.SurveysSettings;
import com.instabug.survey.ui.SurveyActivity;
import com.instabug.survey.ui.ViewType;


/**
 * Created by mohamedzakaria on 8/30/17.
 */

public abstract class ThanksAbstractFragment extends InstabugBaseFragment<ThanksFragmentPresenter>
        implements ThanksFragmentContract.View {
    private static final String KEY_BUNDLE_SURVEY = "key_survey";
    @Nullable
    private ImageView brandingImage;
    @Nullable
    private TextView txtTitle;
    @Nullable
    private TextView txtSubTitle;
    @Nullable
    private LinearLayout poweredByFooter;

    public static ThanksAbstractFragment newInstance(@Nullable Survey survey) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_BUNDLE_SURVEY, survey);
        ThanksAbstractFragment fragment = new ThanksFragment();
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_survey_fragment_thanks_dialog;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        presenter = new ThanksFragmentPresenter(this);
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        ImageView imageView = brandingImage = findViewById(R.id.instabug_img_thanks);
        TextView titleTextView = txtTitle = findViewById(R.id.txt_thanks_title);
        txtSubTitle = findViewById(R.id.txtSubTitle);
        if (titleTextView == null || imageView == null || txtSubTitle == null) return;
        ImageView closeBtn = findViewById(R.id.survey_partial_close_btn);
        if (closeBtn != null) {
            if (AccessibilityUtils.isTalkbackEnabled()) {
                closeBtn.setVisibility(View.VISIBLE);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP_MR1) {
                    closeBtn.setAccessibilityTraversalAfter(closeBtn.getRootView().getId());
                }
                closeBtn.setImportantForAccessibility(
                        View.IMPORTANT_FOR_ACCESSIBILITY_YES
                );
                closeBtn.setOnClickListener((view) -> {
                    SurveyActivity activity = (SurveyActivity) getActivity();
                    if (activity != null) {
                        activity.finishSurvey(false);
                    }
                });
            } else {
                closeBtn.setVisibility(View.GONE);
            }
        }
        setTitle();
        poweredByFooter = findViewById(R.id.instabug_pbi_container);

        if (SurveysSettings.isCustomizationEnabled()
                && getSurvey() != null
                && getSurvey().getType() == SurveyTypes.STORE_RATING) {
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                titleTextView.setTextColor(Color.BLACK);
                if (getContext() != null) {
                    Drawable bgDrawable = ContextCompat.getDrawable(getContext(),
                            R.drawable.ic_suvey_vz_custom_thanks_background);
                    if (bgDrawable != null) {
                        imageView.setBackgroundDrawable(Colorizer.getTintedDrawable(Color.BLACK,
                                bgDrawable));
                    }
                }
            } else {
                titleTextView.setTextColor(Color.WHITE);
                if (getContext() != null) {
                    Drawable bgDrawable = ContextCompat.getDrawable(getContext(),
                            R.drawable.ic_suvey_vz_custom_thanks_background);
                    if (bgDrawable != null) {
                        imageView.setBackgroundDrawable(
                                Colorizer.getTintedDrawable(Color.WHITE,
                                        bgDrawable));
                    }
                }
            }
            imageView.setColorFilter(Color.parseColor("#f5bf56"));
        } else {
            setMessage();
            if (InstabugCore.getTheme() == InstabugColorTheme.InstabugColorThemeLight) {
                titleTextView.setTextColor(getThanksTitleTextColorForLightTheme());
            } else {
                titleTextView.setTextColor(ContextCompat.getColor(requireContext(), android.R.color.white));
            }
            imageView.setColorFilter(getBrandingImageColorFilter());
            if (getContext() != null) {
                Drawable drawable = ContextCompat.getDrawable(getContext(), R.drawable.ibg_survey_ic_thanks_background);
                if (drawable != null) {
                    imageView.setBackgroundDrawable(getBrandingImageBackgroundDrawable(drawable));
                }
            }

        }

        if (presenter != null) {
            presenter.handlePoweredByFooter();
        }
        startIntoAnimation();
        adjustViewsInPrimaryScreen();

        //Set content description for accessibility purposes.
        if (AccessibilityUtils.isTalkbackEnabled() && txtTitle != null && txtSubTitle != null) {
            StringBuilder contentDescription = new StringBuilder();
            if (txtTitle.getText() != null)
                contentDescription.append(txtTitle.getText()).append("\n");
            if (txtSubTitle.getText() != null)
                contentDescription.append(txtSubTitle.getText());
            if (contentDescription.length() > 0)
                rootView.setContentDescription(contentDescription);
        }
    }

    protected int getBrandingImageColorFilter() {
        return InstabugCore.getPrimaryColor();
    }

    protected Drawable getBrandingImageBackgroundDrawable(Drawable drawable) {
        return Colorizer.getPrimaryColorTintedDrawable(drawable);
    }

    protected int getThanksTitleTextColorForLightTheme() {
        return InstabugCore.getPrimaryColor();
    }

    private void setTitle() {
        ThanksFragmentPresenter currentPresenter = presenter;
        if (currentPresenter != null && getSurvey() != null) {
            String title = currentPresenter.getTitle(getSurvey());
            if (title != null && txtTitle != null) {
                txtTitle.setText(title);
            }
        } else {
            if (txtTitle != null) {
                txtTitle.setText(R.string.instabug_custom_survey_thanks_title);
            }
        }
    }

    private void setMessage() {
        ThanksFragmentPresenter currentPresenter = presenter;
        if (currentPresenter != null && getSurvey() != null) {
            String msg = currentPresenter.getMessage(getSurvey());
            if (msg != null && txtSubTitle != null) txtSubTitle.setText(msg);
        } else {
            if (txtSubTitle != null) {
                txtSubTitle.setText(R.string.instabug_custom_survey_thanks_subtitle);
            }
        }
    }

    private void startIntoAnimation() {
        if (getContext() == null) return;

        final Animation a1 = AnimationUtils.loadAnimation(getContext(), R.anim.ib_srv_anim_fade_in_scale);
        final Animation a2 = AnimationUtils.loadAnimation(getContext(), R.anim.ib_srv_anim_fly_in);
        final Animation a3 = AnimationUtils.loadAnimation(getContext(), R.anim.ib_srv_anim_fly_in);
        a2.setStartOffset(300);
        a3.setStartOffset(400);

        if (txtTitle == null) return;
        txtTitle.getViewTreeObserver().addOnGlobalLayoutListener(() -> {
            if (txtTitle == null || brandingImage == null || txtSubTitle == null) return;
            brandingImage.startAnimation(a1);
            txtTitle.startAnimation(a2);
            txtSubTitle.startAnimation(a3);
        });
    }

    @Override
    public void handlePoweredByFooter() {
        if (getContext() != null && poweredByFooter != null) {
            InstabugCore.handlePbiFooter(poweredByFooter);
            InstabugCore.handlePbiFooterThemeColor(
                    poweredByFooter,
                    R.color.pbi_footer_color_dark,
                    R.color.pbi_footer_color_light
            );
        }
    }

    private void adjustViewsInPrimaryScreen() {
        if (getActivity() != null && ((SurveyActivity) getActivity()).getViewState() != null) {
            if (brandingImage != null && ((SurveyActivity) getActivity()).getViewState() == ViewType.PRIMARY) {
                LinearLayout.LayoutParams params = (LinearLayout.LayoutParams) brandingImage
                        .getLayoutParams();
                params.setMargins(0, 0, 0, 16);
                brandingImage.setLayoutParams(params);
            }
        }
    }

    @Nullable
    private Survey getSurvey() {
        if (getArguments() != null) {
            return (Survey) getArguments().getSerializable(KEY_BUNDLE_SURVEY);
        }
        return null;
    }

    public String getLocalizedString(@StringRes int resourceId) {
        return LocaleUtils.getLocaleStringResource(InstabugCore.getLocale(getContext()),
                resourceId,
                getContext());
    }

}
