package com.instabug.survey.models;

import androidx.annotation.Keep;
import androidx.annotation.StringDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@Retention(RetentionPolicy.SOURCE)
@StringDef({State.DISMISSED, State.ENDED, State.SUBMITTED})

/** A {@link StringDef} to describe the state of the Survey when on finishing */

@Keep
public @interface State {

    // Dismissed at start
    String DISMISSED = "DISMISSED";

    // Dismissed midway (One or more questions were answered and then the user dismissed the Survey)
    String ENDED = "ENDED";

    // The Survey questions were all answered and the user submitted the Survey
    String SUBMITTED = "SUBMITTED";
}
