package com.instabug.survey.callbacks;

import androidx.annotation.Keep;

import com.instabug.survey.models.State;

import org.json.JSONObject;

@Keep
public interface OnFinishCallback {

    /**
     * This block is executed when the survey is dismissed at the start, midway, or when the survey is submitted.
     *
     * @param surveyId A string with the survey's identifier
     * @param response A {@link JSONObject} carrying info about the survey and the questions' responses
     * @param state   A {@link androidx.annotation.StringDef} of type {@link State} describing the state of the survey on finishing,
     *                 whether it was dismissed at start or midway or completed
     */
    void onFinish(String surveyId, @State String state, JSONObject response);
}
