package com.instabug.survey.announcements.models;

import androidx.annotation.Nullable;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import static com.instabug.survey.announcements.models.AnnouncementType.UPDATE_MSG;
import static com.instabug.survey.announcements.models.AnnouncementType.WHAT_IS_NEW;

/**
 * Created by Barakat on 20/12/2018
 */
public class AnnouncementItem implements Serializable, Cacheable {

    private static final String KEY_TITLE = "title";
    private static final String KEY_OPTIONS = "options";
    private static final String KEY_FEATURE = "features";
    private static final String KEY_TYPE = "type";
    private static final String KEY_ID = "id";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_ANSWER = "answer";
    private static final String KEY_CONFIG = "config";
    @Nullable
    private String title;
    @Nullable
    private String description;
    @Nullable
    private String answer;
    private long id;
    @Nullable
    private ArrayList<NewFeature> newFeatures;
    @Nullable
    private ArrayList<String> options;
    @AnnouncementType
    private int type;
    private boolean hasNoIcons;
    @Nullable
    private AnnouncementConfig announcementConfig;

    public static ArrayList<AnnouncementItem> fromJson(JSONArray featuresJsonArray) throws JSONException {
        ArrayList<AnnouncementItem> newFeaturesList = new ArrayList<>();
        if (featuresJsonArray != null) {
            for (int i = 0; i < featuresJsonArray.length(); i++) {
                JSONObject featureJSONObject = featuresJsonArray.getJSONObject(i);
                AnnouncementItem announcementItem = new AnnouncementItem();
                announcementItem.fromJson(featureJSONObject.toString());
                newFeaturesList.add(announcementItem);
            }
        }
        return newFeaturesList;
    }

    public static JSONArray toJson(@Nullable ArrayList<AnnouncementItem> announcementsArrayList) throws JSONException {
        JSONArray announcementJSONArray = new JSONArray();
        if (announcementsArrayList != null) {
            for (AnnouncementItem announcementItem : announcementsArrayList) {
                announcementJSONArray.put(new JSONObject(announcementItem.toJson()));
            }
        }
        return announcementJSONArray;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();

        jsonObject.put(KEY_ID, getId())
                .put(KEY_TITLE, getTitle() != null ? getTitle() : "")
                .put(KEY_OPTIONS, getOptions() != null ? new JSONArray(getOptions()) : new JSONArray())
                .put(KEY_FEATURE, NewFeature.toJson(getNewFeatures()))
                .put(KEY_TYPE, getType())
                .put(KEY_ANSWER, getAnswer() != null ? getAnswer() : "")
                .put(KEY_DESCRIPTION, getDescription() != null ? getDescription() : "")
                .put(KEY_TYPE, getType())
                .put(KEY_CONFIG, AnnouncementConfig.toJson(getAnnouncementConfig()));
        return jsonObject.toString();
    }

    @Nullable
    public AnnouncementConfig getAnnouncementConfig() {
        return announcementConfig;
    }

    public void setAnnouncementConfig(@Nullable AnnouncementConfig announcementConfig) {
        this.announcementConfig = announcementConfig;
    }

    @Nullable
    public String getAnswer() {
        return answer;
    }

    public void setAnswer(@Nullable String answer) {
        this.answer = answer;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public ArrayList<NewFeature> getNewFeatures() {
        return newFeatures;
    }

    public void setNewFeatures(@Nullable ArrayList<NewFeature> newFeatures) {
        this.newFeatures = newFeatures;
    }

    @Nullable
    public List<String> getOptions() {
        return options;
    }

    public void setOptions(@Nullable ArrayList<String> options) {
        this.options = options;
    }

    @Nullable
    public String getTitle() {
        return title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getType() {
        return type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jsonObject = new JSONObject(modelAsJson);
        if (jsonObject.has(KEY_ID)) {
            this.setId(jsonObject.getLong(KEY_ID));
        }
        if (jsonObject.has(KEY_TITLE)) {
            this.setTitle(jsonObject.getString(KEY_TITLE));
        }
        if (jsonObject.has(KEY_DESCRIPTION)) {
            this.setDescription(jsonObject.getString(KEY_DESCRIPTION));
        }
        if (jsonObject.has(KEY_OPTIONS)) {
            JSONArray answersJsonArray = jsonObject.getJSONArray(KEY_OPTIONS);
            ArrayList<String> options = new ArrayList<>();
            for (int i = 0; i < answersJsonArray.length(); i++) {
                options.add(answersJsonArray.getString(i));
            }
            this.setOptions(options);
        }
        if (jsonObject.has(KEY_FEATURE)) {
            this.setNewFeatures(NewFeature.fromJson(jsonObject.getJSONArray(KEY_FEATURE)));
        }
        if (jsonObject.has(KEY_TYPE)) {
            this.setType(jsonObject.getInt(KEY_TYPE));
        }
        if (jsonObject.has(KEY_ANSWER)) {
            this.setAnswer(jsonObject.getString(KEY_ANSWER));
        }
        if (jsonObject.has(KEY_CONFIG)) {
            this.setAnnouncementConfig(AnnouncementConfig.fromJson(jsonObject.getJSONObject(KEY_CONFIG)));
        }
    }

    public boolean hasNoIcons() {
        return hasNoIcons;
    }

    public void setHasNoIcons() {
        this.hasNoIcons = true;
        if (getNewFeatures() == null) return;

        for (NewFeature newFeature : getNewFeatures()) {
            if (newFeature.getIconUrl() != null && !newFeature.getIconUrl().equals("")) {
                this.hasNoIcons = false;
            }
        }

    }

    public String getTypeAsString() {
        switch (type) {
            case WHAT_IS_NEW:
                return "WhatsNew";
            case UPDATE_MSG:
                return "UpdateMessage";
            default:
                return "";
        }
    }
}
