package com.instabug.survey.ui.survey.starrating;

import android.os.Bundle;
import android.view.View;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;

import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.ui.custom.RatingAbstractView;
import com.instabug.survey.ui.survey.QuestionFragment;
import com.instabug.survey.ui.survey.SurveyFragmentCallbacks;

import org.jetbrains.annotations.NotNull;

/**
 * Created by mohamedzakaria on 7/31/17.
 */

public abstract class StarRatingQuestionAbstractFragment extends QuestionFragment implements RatingAbstractView
        .OnRatingBarChangeListener {
    @Nullable
    protected RatingAbstractView ratingBar;

    public static StarRatingQuestionAbstractFragment newInstance(boolean shouldChangeContainerHeight, Question question,
                                                                 SurveyFragmentCallbacks surveyFragmentCallbacks) {
        Bundle args = new Bundle();
        args.putSerializable(KEY_QUESTION_ARGUMENT, question);
        args.putSerializable(KEY_SHOULD_CHANGE_CONTAINER_HEIGHT_ARGUMENT, shouldChangeContainerHeight);
        StarRatingQuestionAbstractFragment fragment = new StarRatingQuestionFragment();
        fragment.setArguments(args);
        fragment.setSurveyFragmentCallbacks(surveyFragmentCallbacks);
        return fragment;
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
        if (getArguments() != null)
            question = (Question) getArguments().getSerializable(KEY_QUESTION_ARGUMENT);
    }

    @Override
    @CallSuper
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        super.initViews(rootView, savedInstanceState);
        ratingBar = (RatingAbstractView) rootView.findViewById(R.id.ib_ratingbar);
        if (ratingBar != null) {
            ratingBar.setOnRatingBarChangeListener(this);
        }
    }

    private void handleSelectedAnswer(Question question) {
        if (question.getAnswer() != null && !question.getAnswer().isEmpty()) {
            if (ratingBar != null) {
                ratingBar.setRating(Float.valueOf(question.getAnswer()), false);
            }
        }
    }

    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        showRatingQuestion(question);
    }

    protected void showRatingQuestion(@Nullable Question question) {
        if (questionTextView == null || question == null || question.getTitle() == null) return;
        questionTextView.setText(getQuestionTitle(question.getTitle()));
        handleSelectedAnswer(question);
    }

    protected String getQuestionTitle(String questionTitle) {
        return questionTitle;
    }

    @Override
    @Nullable
    public String getAnswer() {
        if (ratingBar != null) {
            return ((int) ratingBar.getRating()) + "";
        }
        return null;
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_star_rating_question;
    }

    @Override
    public void onRatingChanged(RatingAbstractView simpleRatingBar, float rating, boolean fromUser) {
        if (question == null) return;

        if (rating >= 1.0f) {
            question.setAnswer((int) rating + "");
        } else {
            question.setAnswer(null);
        }
        if (surveyFragmentCallbacks != null) {
            surveyFragmentCallbacks.onAnswerRateQuestion(question);
        }
    }

    @Nullable
    public Question getQuestion() {
        return question;
    }

}