package com.instabug.survey.ui.popup;

import android.content.Context;
import android.os.Bundle;
import android.view.View;

import androidx.annotation.Nullable;

import com.instabug.library.Instabug;
import com.instabug.library.core.ui.InstabugBaseFragment;
import com.instabug.survey.R;
import com.instabug.survey.models.Question;
import com.instabug.survey.models.Survey;
import com.instabug.survey.ui.SurveyActivityCallback;
import com.instabug.survey.utils.PlayStoreUtils;


/**
 * Created by Barakat on 10/12/2018
 */
public abstract class PopupAbstractQuestionFragment extends InstabugBaseFragment<PopupQuestionPresenter> implements
        PopupQuestionContract.View {

    protected final static String KEY_SURVEY_ARGUMENT = "KEY_SURVEY_ARGUMENT";
    @Nullable
    protected PopupQuestionPresenter presenter;
    private SurveyActivityCallback callback;

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRetainInstance(true);
    }

    @Override
    protected int getLayout() {
        return R.layout.instabug_dialog_popup_survey;
    }

    @Override
    protected void initViews(View rootView, @Nullable Bundle savedInstanceState) {
        Survey survey = null;
        if (getArguments() != null) {
            survey = (Survey) getArguments().getSerializable(KEY_SURVEY_ARGUMENT);
        }
        if (survey != null) {

            presenter = new PopupQuestionPresenter(this, survey);

            presenter.showPrimaryQuestion();
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            callback = (SurveyActivityCallback) context;
        } catch (IllegalStateException ex) {
            throw new IllegalStateException("Survey Activity must implement SurveyActivityCallback");
        }
    }

    @Override
    public void onBetaAppPrimaryQuestionAnswered(Survey survey) {
        callback.submitSurvey(survey);
    }

    @Override
    public void onPositiveSecondaryQuestionNegativeResponse(Survey survey) {
        callback.submitSurvey(survey);
    }

    @Override
    public void onPositiveSecondaryQuestionPositiveResponse(Survey survey) {
        if (getContext() == null) return;
        Instabug.willRedirectToStore();
        PlayStoreUtils.rateNow(getContext());
        callback.submitSurvey(survey);
    }

    @Override
    public void showNegativeSecondaryQuestion(Survey survey) {
        Question secondaryNegativeQuestion = survey.getSecondaryNegativeQuestion();
        if (getFragmentManager() == null || secondaryNegativeQuestion == null) return;

        navigateToNegativeSecondaryQuestionFragment(survey, secondaryNegativeQuestion);
    }

    protected abstract void navigateToNegativeSecondaryQuestionFragment(Survey survey, Question question);

    @Override
    public abstract void showPrimaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA);

    @Override
    public abstract void showAlertForPositiveSecondaryQuestion(@Nullable String title, @Nullable String message, String positiveCTA, String negativeCTA);

    @Override
    public void dismissSurvey(Survey survey) {
        callback.dismissSurvey(survey);
    }

    @Override
    public void submitSurvey(Survey survey) {
        callback.submitSurvey(survey);
    }
}
