package com.instabug.survey.models;

import android.os.Parcel;
import android.os.Parcelable;

import com.instabug.library.internal.storage.cache.Cacheable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.Serializable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

import androidx.annotation.Nullable;
import androidx.annotation.StringDef;

/**
 * Created by Barakat on 03/12/2018
 */
public class ThankYouItem implements Cacheable, Serializable {

    //Serialization Keys
    private static final String KEY_TITLE = "title";
    private static final String USER_ACTION_CLASS = "user_class";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_APP_STORE_ENABLED = "appstore_enabled";
    private static final String KEY_CTA_STRING = "call_to_action";

    private @UserActionClass
    @Nullable
    String responseScoreType;
    @Nullable
    private String thankYouTitle;
    @Nullable
    private String thankYouMessage;
    @Nullable
    private String callActionString;
    private boolean appStoreRatingEnabled;

    public ThankYouItem() {
    }

    public static ArrayList<ThankYouItem> fromJson(JSONArray thankYouJsonArray) throws JSONException {
        ArrayList<ThankYouItem> thankYouItems = new ArrayList<>();
        if (thankYouJsonArray != null) {
            for (int i = 0; i < thankYouJsonArray.length(); i++) {
                ThankYouItem thankYouItem = new ThankYouItem();
                JSONObject jsonItem = thankYouJsonArray.getJSONObject(i);
                thankYouItem.fromJson(jsonItem.toString());
                thankYouItems.add(thankYouItem);
            }
        }
        return thankYouItems;
    }

    public static JSONArray toJson(ArrayList<ThankYouItem> thankYouItems) throws JSONException {
        JSONArray thankYouJsonArray = new JSONArray();
        if (thankYouItems != null) {
            for (int i = 0; i < thankYouItems.size(); i++) {
                thankYouJsonArray.put(new JSONObject(thankYouItems.get(i).toJson()));
            }
        }
        return thankYouJsonArray;
    }

    @Nullable
    public String getThankYouTitle() {
        return thankYouTitle;
    }

    public void setThankYouTitle(@Nullable String thankYouTitle) {
        this.thankYouTitle = thankYouTitle;
    }

    @Nullable
    public String getThankYouMessage() {
        return thankYouMessage;
    }

    public void setThankYouMessage(@Nullable String thankYouMessage) {
        this.thankYouMessage = thankYouMessage;
    }

    @Nullable
    public String getCallActionString() {
        return callActionString;
    }

    public void setCallActionString(@Nullable String callActionString) {
        this.callActionString = callActionString;
    }

    public boolean isAppStoreRatingEnabled() {
        return appStoreRatingEnabled;
    }

    public void setAppStoreRatingEnabled(boolean appStoreRatingEnabled) {
        this.appStoreRatingEnabled = appStoreRatingEnabled;
    }

    @Nullable
    public String getResponseScoreType() {
        return responseScoreType;
    }

    public void setResponseScoreType(@Nullable String responseScoreType) {
        this.responseScoreType = responseScoreType;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(KEY_TITLE, thankYouTitle != null ? thankYouTitle : "");
        jsonObject.put(KEY_MESSAGE, thankYouMessage != null ? thankYouMessage : "");
        jsonObject.put(USER_ACTION_CLASS, responseScoreType != null ? responseScoreType : "");
        jsonObject.put(KEY_CTA_STRING, callActionString != null ? callActionString : "");
        jsonObject.put(KEY_APP_STORE_ENABLED, appStoreRatingEnabled);
        return jsonObject.toString();
    }

    @Override
    public void fromJson(String modelAsJson) throws JSONException {
        JSONObject jsonObject = new JSONObject(modelAsJson);
        setThankYouTitle(jsonObject.optString(KEY_TITLE));
        setThankYouMessage(jsonObject.optString(KEY_MESSAGE));
        setCallActionString(jsonObject.optString(KEY_CTA_STRING));
        setResponseScoreType(jsonObject.optString(USER_ACTION_CLASS));
        setAppStoreRatingEnabled(jsonObject.optBoolean(KEY_APP_STORE_ENABLED, false));
    }

    @Retention(RetentionPolicy.SOURCE)
    @StringDef({
            UserActionClass.PROMOTER,
            UserActionClass.PASSIVE,
            UserActionClass.DETRACTOR
    })
    public @interface UserActionClass {
        String PROMOTER = "promoter";
        String PASSIVE = "passive";
        String DETRACTOR = "detractor";
    }

    protected ThankYouItem(Parcel in) {
        this.responseScoreType = in.readString();
        this.thankYouTitle = in.readString();
        this.thankYouMessage = in.readString();
        this.callActionString = in.readString();
        this.appStoreRatingEnabled = in.readByte() != 0;
    }

    public static final Parcelable.Creator<ThankYouItem> CREATOR = new Parcelable.Creator<ThankYouItem>() {
        @Override
        public ThankYouItem createFromParcel(Parcel source) {
            return new ThankYouItem(source);
        }

        @Override
        public ThankYouItem[] newArray(int size) {
            return new ThankYouItem[size];
        }
    };
}
